/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.integration.channel.NullChannel;

class DefaultConfiguringBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final String ERROR_LOGGER_BEAN_NAME = "_org.springframework.integration.errorLogger";
    private Log logger = LogFactory.getLog(this.getClass());

    DefaultConfiguringBeanFactoryPostProcessor() {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            this.registerNullChannel(registry);
            if (!beanFactory.containsBean("errorChannel")) {
                this.registerErrorChannel(registry);
            }
            if (!beanFactory.containsBean("taskScheduler")) {
                this.registerTaskScheduler(registry);
            }
            this.registerIdGeneratorConfigurer(registry);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"BeanFactory is not a BeanDefinitionRegistry. The default 'errorChannel' and 'taskScheduler' cannot be configured. Also, any custom IdGenerator implementation configured in this BeanFactory will not be recognized.");
        }
    }

    private void registerIdGeneratorConfigurer(BeanDefinitionRegistry registry) {
        String[] definitionNames;
        String listenerClassName = "org.springframework.integration.config.IdGeneratorConfigurer";
        for (String definitionName : definitionNames = registry.getBeanDefinitionNames()) {
            BeanDefinition definition = registry.getBeanDefinition(definitionName);
            if (!listenerClassName.equals(definition.getBeanClassName())) continue;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)(listenerClassName + " is already registered and will be used"));
            }
            return;
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition(listenerClassName);
        beanDefinition.setRole(2);
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
    }

    private void registerNullChannel(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition("nullChannel")) {
            BeanDefinition nullChannelDefinition = registry.getBeanDefinition("nullChannel");
            if (NullChannel.class.getName().equals(nullChannelDefinition.getBeanClassName())) {
                return;
            }
            throw new IllegalStateException("The bean name 'nullChannel' is reserved.");
        }
        RootBeanDefinition nullChannelDef = new RootBeanDefinition();
        nullChannelDef.setBeanClassName("org.springframework.integration.channel.NullChannel");
        BeanDefinitionHolder nullChannelHolder = new BeanDefinitionHolder((BeanDefinition)nullChannelDef, "nullChannel");
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)nullChannelHolder, (BeanDefinitionRegistry)registry);
    }

    private void registerErrorChannel(BeanDefinitionRegistry registry) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"No bean named 'errorChannel' has been explicitly defined. Therefore, a default PublishSubscribeChannel will be created.");
        }
        RootBeanDefinition errorChannelDef = new RootBeanDefinition();
        errorChannelDef.setBeanClassName("org.springframework.integration.channel.PublishSubscribeChannel");
        BeanDefinitionHolder errorChannelHolder = new BeanDefinitionHolder((BeanDefinition)errorChannelDef, "errorChannel");
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)errorChannelHolder, (BeanDefinitionRegistry)registry);
        BeanDefinitionBuilder loggingHandlerBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.handler.LoggingHandler");
        loggingHandlerBuilder.addConstructorArgValue((Object)"ERROR");
        BeanDefinitionBuilder loggingEndpointBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.endpoint.EventDrivenConsumer");
        loggingEndpointBuilder.addConstructorArgReference("errorChannel");
        loggingEndpointBuilder.addConstructorArgValue((Object)loggingHandlerBuilder.getBeanDefinition());
        BeanComponentDefinition componentDefinition = new BeanComponentDefinition((BeanDefinition)loggingEndpointBuilder.getBeanDefinition(), ERROR_LOGGER_BEAN_NAME);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)componentDefinition, (BeanDefinitionRegistry)registry);
    }

    private void registerTaskScheduler(BeanDefinitionRegistry registry) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"No bean named 'taskScheduler' has been explicitly defined. Therefore, a default ThreadPoolTaskScheduler will be created.");
        }
        BeanDefinitionBuilder schedulerBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler");
        schedulerBuilder.addPropertyValue("poolSize", (Object)10);
        schedulerBuilder.addPropertyValue("threadNamePrefix", (Object)"task-scheduler-");
        schedulerBuilder.addPropertyValue("rejectedExecutionHandler", (Object)new ThreadPoolExecutor.CallerRunsPolicy());
        BeanDefinitionBuilder errorHandlerBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.channel.MessagePublishingErrorHandler");
        errorHandlerBuilder.addPropertyReference("defaultErrorChannel", "errorChannel");
        schedulerBuilder.addPropertyValue("errorHandler", (Object)errorHandlerBuilder.getBeanDefinition());
        BeanComponentDefinition schedulerComponent = new BeanComponentDefinition((BeanDefinition)schedulerBuilder.getBeanDefinition(), "taskScheduler");
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)schedulerComponent, (BeanDefinitionRegistry)registry);
    }
}

