/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.handler.ExpressionEvaluatingMessageHandler;
import org.springframework.integration.handler.MethodInvokingMessageHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class DefaultOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanComponentDefinition innerConsumerDefinition = IntegrationNamespaceUtils.parseInnerHandlerDefinition(element, parserContext);
        String consumerRef = element.getAttribute("ref");
        String methodName = element.getAttribute("method");
        String consumerExpressionString = element.getAttribute("expression");
        boolean isInnerConsumer = innerConsumerDefinition != null;
        boolean isRef = StringUtils.hasText((String)consumerRef);
        boolean isExpression = StringUtils.hasText((String)consumerExpressionString);
        boolean hasMethod = StringUtils.hasText((String)methodName);
        if (!(isInnerConsumer ^ (isRef ^ isExpression))) {
            parserContext.getReaderContext().error("Exactly one of the 'ref', 'expression' or inner bean is required.", (Object)element);
        }
        if (hasMethod & isExpression) {
            parserContext.getReaderContext().error("The 'method' attribute cannot be used with the 'expression' attribute.", (Object)element);
        }
        BeanDefinitionBuilder consumerBuilder = null;
        if (isExpression) {
            consumerBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionEvaluatingMessageHandler.class);
            RootBeanDefinition expressionDef = new RootBeanDefinition(ExpressionFactoryBean.class);
            expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)consumerExpressionString);
            consumerBuilder.addConstructorArgValue((Object)expressionDef);
        } else {
            consumerBuilder = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingMessageHandler.class);
            if (isRef) {
                consumerBuilder.addConstructorArgReference(consumerRef);
            } else {
                consumerBuilder.addConstructorArgValue((Object)innerConsumerDefinition);
            }
            consumerBuilder.addConstructorArgValue((Object)(hasMethod ? methodName : "handleMessage"));
        }
        consumerBuilder.addPropertyValue("componentType", (Object)"outbound-channel-adapter");
        return consumerBuilder.getBeanDefinition();
    }
}

