/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.config.xml.WireTapParser;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GlobalChannelInterceptorParser
extends AbstractBeanDefinitionParser {
    private static final String BASE_PACKAGE = "org.springframework.integration.channel.interceptor.";
    private static final String CHANNEL_NAME_PATTERN_ATTRIBUTE = "pattern";
    private static final String REF_ATTRIBUTE = "ref";
    private static final String GLOBAL_POST_PROCESSOR_CLASSNAME = "GlobalChannelInterceptorBeanPostProcessor";
    private final ManagedList<RuntimeBeanReference> globalInterceptors = new ManagedList();
    private volatile boolean postProcessorCreated;

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        this.createAndRegisterGlobalPostProcessorIfNecessary(parserContext);
        BeanDefinitionBuilder globalChannelInterceptorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.channel.interceptor.GlobalChannelInterceptorWrapper");
        Object childBeanDefinition = this.getBeanDefinitionBuilderConstructorValue(element, parserContext);
        globalChannelInterceptorBuilder.addConstructorArgValue(childBeanDefinition);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(globalChannelInterceptorBuilder, element, "order");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(globalChannelInterceptorBuilder, element, CHANNEL_NAME_PATTERN_ATTRIBUTE, "patterns");
        String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)globalChannelInterceptorBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)globalChannelInterceptorBuilder.getBeanDefinition(), beanName));
        this.globalInterceptors.add((Object)new RuntimeBeanReference(beanName));
        return null;
    }

    private void createAndRegisterGlobalPostProcessorIfNecessary(ParserContext parserContext) {
        if (!this.postProcessorCreated) {
            BeanDefinitionBuilder postProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.channel.interceptor.GlobalChannelInterceptorBeanPostProcessor");
            postProcessorBuilder.addConstructorArgValue(this.globalInterceptors);
            AbstractBeanDefinition beanDef = postProcessorBuilder.getBeanDefinition();
            String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, beanName));
            this.postProcessorCreated = true;
        }
    }

    protected Object getBeanDefinitionBuilderConstructorValue(Element element, ParserContext parserContext) {
        BeanComponentDefinition interceptorBeanDefinition = IntegrationNamespaceUtils.parseInnerHandlerDefinition(element, parserContext);
        if (interceptorBeanDefinition != null) {
            return interceptorBeanDefinition;
        }
        String beanName = null;
        if (element.hasAttribute(REF_ATTRIBUTE)) {
            beanName = element.getAttribute(REF_ATTRIBUTE);
        } else {
            List els = DomUtils.getChildElements((Element)element);
            if (els.isEmpty()) {
                parserContext.getReaderContext().error("child BeanDefinition must not be null", (Object)element);
            } else {
                Element child = (Element)els.get(0);
                if ("wire-tap".equals(child.getLocalName())) {
                    beanName = new WireTapParser().parse(child, parserContext);
                } else {
                    BeanDefinition beanDef = parserContext.getDelegate().parseCustomElement(child);
                    beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
                }
            }
        }
        return new RuntimeBeanReference(beanName);
    }
}

