/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractTransformerParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.expression.DynamicExpression;
import org.springframework.integration.transformer.HeaderEnricher;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HeaderEnricherParserSupport
extends AbstractTransformerParser {
    private final Map<String, String> elementToNameMap = new HashMap<String, String>();
    private final Map<String, Class<?>> elementToTypeMap = new HashMap();

    @Override
    protected final String getTransformerClassName() {
        return HeaderEnricher.class.getName();
    }

    protected final void addElementToHeaderMapping(String elementName, String headerName) {
        this.addElementToHeaderMapping(elementName, headerName, null);
    }

    protected final void addElementToHeaderMapping(String elementName, String headerName, Class<?> headerType) {
        this.elementToNameMap.put(elementName, headerName);
        if (headerType != null) {
            this.elementToTypeMap.put(elementName, headerType);
        }
    }

    @Override
    protected void parseTransformer(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ManagedMap headers = new ManagedMap();
        this.processHeaders(element, (ManagedMap<String, Object>)headers, parserContext);
        builder.addConstructorArgValue((Object)headers);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "default-overwrite");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "should-skip-nulls");
        this.postProcessHeaderEnricher(builder, element, parserContext);
    }

    protected void processHeaders(Element element, ManagedMap<String, Object> headers, ParserContext parserContext) {
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            boolean isCustomBean;
            String headerTypeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String headerName = null;
            Element headerElement = (Element)node;
            String elementName = node.getLocalName();
            Class headerType = null;
            if ("header".equals(elementName)) {
                headerName = headerElement.getAttribute("name");
            } else {
                headerName = this.elementToNameMap.get(elementName);
                headerType = this.elementToTypeMap.get(elementName);
                if (headerType != null && StringUtils.hasText((String)headerElement.getAttribute("type"))) {
                    parserContext.getReaderContext().error("The " + elementName + " header does not accept a 'type' attribute. The required type is [" + headerType.getName() + "]", (Object)element);
                }
            }
            if (headerType == null && StringUtils.hasText((String)(headerTypeName = headerElement.getAttribute("type")))) {
                ClassLoader classLoader = parserContext.getReaderContext().getBeanClassLoader();
                if (classLoader == null) {
                    classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                }
                try {
                    headerType = ClassUtils.forName((String)headerTypeName, (ClassLoader)classLoader);
                }
                catch (Exception e) {
                    parserContext.getReaderContext().error("unable to resolve type [" + headerTypeName + "] for header '" + headerName + "'", (Object)element, (Throwable)e);
                }
            }
            if (headerName == null) continue;
            String value = headerElement.getAttribute("value");
            String ref = headerElement.getAttribute("ref");
            String method = headerElement.getAttribute("method");
            String expression = headerElement.getAttribute("expression");
            Element beanElement = null;
            Element scriptElement = null;
            Element expressionElement = null;
            List subElements = DomUtils.getChildElements((Element)headerElement);
            if (!subElements.isEmpty()) {
                Element subElement = (Element)subElements.get(0);
                String subElementLocalName = subElement.getLocalName();
                if ("bean".equals(subElementLocalName)) {
                    beanElement = subElement;
                } else if ("script".equals(subElementLocalName)) {
                    scriptElement = subElement;
                } else if ("expression".equals(subElementLocalName)) {
                    expressionElement = subElement;
                }
                if (beanElement == null && scriptElement == null && expressionElement == null) {
                    parserContext.getReaderContext().error("Only 'bean', 'script' or 'expression' can be defined as a sub-element", (Object)element);
                }
            }
            if (StringUtils.hasText((String)expression) && expressionElement != null) {
                parserContext.getReaderContext().error("The 'expression' attribute and sub-element are mutually exclusive", (Object)element);
            }
            boolean isValue = StringUtils.hasText((String)value);
            boolean isRef = StringUtils.hasText((String)ref);
            boolean hasMethod = StringUtils.hasText((String)method);
            boolean isExpression = StringUtils.hasText((String)expression) || expressionElement != null;
            boolean isScript = scriptElement != null;
            BeanDefinition innerComponentDefinition = null;
            if (beanElement != null) {
                innerComponentDefinition = parserContext.getDelegate().parseBeanDefinitionElement(beanElement).getBeanDefinition();
            } else if (isScript) {
                innerComponentDefinition = parserContext.getDelegate().parseCustomElement(scriptElement);
            }
            boolean bl = isCustomBean = innerComponentDefinition != null;
            if (hasMethod && isScript) {
                parserContext.getReaderContext().error("The 'method' attribute cannot be used when a 'script' sub-element is defined", (Object)element);
            }
            if (!(isValue ^ (isRef ^ (isExpression ^ isCustomBean)))) {
                parserContext.getReaderContext().error("Exactly one of the 'ref', 'value', 'expression' or inner bean is required.", (Object)element);
            }
            BeanDefinitionBuilder valueProcessorBuilder = null;
            if (isValue) {
                if (hasMethod) {
                    parserContext.getReaderContext().error("The 'method' attribute cannot be used with the 'value' attribute.", (Object)element);
                }
                String headerValue = headerType != null ? new TypedStringValue(value, headerType) : value;
                valueProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.transformer.HeaderEnricher$StaticHeaderValueMessageProcessor");
                valueProcessorBuilder.addConstructorArgValue((Object)headerValue);
            } else if (isExpression) {
                if (hasMethod) {
                    parserContext.getReaderContext().error("The 'method' attribute cannot be used with the 'expression' attribute.", (Object)element);
                }
                valueProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.transformer.HeaderEnricher$ExpressionEvaluatingHeaderValueMessageProcessor");
                if (expressionElement != null) {
                    BeanDefinitionBuilder dynamicExpressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(DynamicExpression.class);
                    dynamicExpressionBuilder.addConstructorArgValue((Object)expressionElement.getAttribute("key"));
                    dynamicExpressionBuilder.addConstructorArgReference(expressionElement.getAttribute("source"));
                    valueProcessorBuilder.addConstructorArgValue((Object)dynamicExpressionBuilder.getBeanDefinition());
                } else {
                    valueProcessorBuilder.addConstructorArgValue((Object)expression);
                }
                valueProcessorBuilder.addConstructorArgValue((Object)headerType);
            } else if (isCustomBean) {
                if (StringUtils.hasText((String)headerElement.getAttribute("type"))) {
                    parserContext.getReaderContext().error("The 'type' attribute cannot be used with an inner bean.", (Object)element);
                }
                if (hasMethod || isScript) {
                    valueProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.transformer.HeaderEnricher$MessageProcessingHeaderValueMessageProcessor");
                    valueProcessorBuilder.addConstructorArgValue((Object)innerComponentDefinition);
                    if (hasMethod) {
                        valueProcessorBuilder.addConstructorArgValue((Object)method);
                    }
                } else {
                    valueProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.transformer.HeaderEnricher$StaticHeaderValueMessageProcessor");
                    valueProcessorBuilder.addConstructorArgValue((Object)innerComponentDefinition);
                }
            } else {
                if (StringUtils.hasText((String)headerElement.getAttribute("type"))) {
                    parserContext.getReaderContext().error("The 'type' attribute cannot be used with the 'ref' attribute.", (Object)element);
                }
                if (hasMethod) {
                    valueProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.transformer.HeaderEnricher$MessageProcessingHeaderValueMessageProcessor");
                    valueProcessorBuilder.addConstructorArgReference(ref);
                    valueProcessorBuilder.addConstructorArgValue((Object)method);
                } else {
                    valueProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.transformer.HeaderEnricher$StaticHeaderValueMessageProcessor");
                    valueProcessorBuilder.addConstructorArgReference(ref);
                }
            }
            IntegrationNamespaceUtils.setValueIfAttributeDefined(valueProcessorBuilder, headerElement, "overwrite");
            headers.put((Object)headerName, (Object)valueProcessorBuilder.getBeanDefinition());
        }
    }

    protected void postProcessHeaderEnricher(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
    }
}

