/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.MatchAlwaysTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntegrationNamespaceUtils {
    static final String BASE_PACKAGE = "org.springframework.integration";
    static final String REF_ATTRIBUTE = "ref";
    static final String METHOD_ATTRIBUTE = "method";
    static final String ORDER = "order";
    static final String EXPRESSION_ATTRIBUTE = "expression";
    public static final String HANDLER_ALIAS_SUFFIX = ".handler";
    public static final String REQUEST_HANDLER_ADVICE_CHAIN = "request-handler-advice-chain";
    public static String DEFAULT_MAX_UNICAST_SUBSCRIBERS_PROPERTY_NAME = "defaultMaxUnicastSubscribers";
    public static String DEFAULT_MAX_BROADCAST_SUBSCRIBERS_PROPERTY_NAME = "defaultMaxBroadcastSubscribers";

    public static void setValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName, String propertyName) {
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, attributeName, propertyName, false);
    }

    public static void setValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, attributeName, false);
    }

    public static void setValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName, String propertyName, boolean emptyStringAllowed) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue) || emptyStringAllowed && element.hasAttribute(attributeName)) {
            builder.addPropertyValue(propertyName, (Object)new TypedStringValue(attributeValue));
        }
    }

    public static void setValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName, boolean emptyStringAllowed) {
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, attributeName, Conventions.attributeNameToPropertyName((String)attributeName), emptyStringAllowed);
    }

    public static void setReferenceIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName, String propertyName) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue)) {
            builder.addPropertyReference(propertyName, attributeValue);
        }
    }

    public static void setReferenceIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, attributeName, Conventions.attributeNameToPropertyName((String)attributeName));
    }

    public static String createElementDescription(Element element) {
        String elementId = "'" + element.getNodeName() + "'";
        String id = element.getAttribute("id");
        if (StringUtils.hasText((String)id)) {
            elementId = elementId + " with id='" + id + "'";
        }
        return elementId;
    }

    public static void configurePollerMetadata(Element pollerElement, BeanDefinitionBuilder targetBuilder, ParserContext parserContext) {
        if (pollerElement.hasAttribute(REF_ATTRIBUTE)) {
            int numberOfAttributes = pollerElement.getAttributes().getLength();
            if (!(numberOfAttributes == 1 || numberOfAttributes == 2 && pollerElement.hasAttribute("default") && pollerElement.getAttribute("default").equals("false"))) {
                parserContext.getReaderContext().error("A 'poller' element that provides a 'ref' must have no other attributes.", (Object)pollerElement);
            }
            if (pollerElement.getChildNodes().getLength() != 0) {
                parserContext.getReaderContext().error("A 'poller' element that provides a 'ref' must have no child elements.", (Object)pollerElement);
            }
            targetBuilder.addPropertyReference("pollerMetadata", pollerElement.getAttribute(REF_ATTRIBUTE));
        } else {
            BeanDefinition beanDefinition = parserContext.getDelegate().parseCustomElement(pollerElement, (BeanDefinition)targetBuilder.getBeanDefinition());
            if (beanDefinition == null) {
                parserContext.getReaderContext().error("BeanDefinition must not be null", (Object)pollerElement);
            }
            targetBuilder.addPropertyValue("pollerMetadata", (Object)beanDefinition);
        }
    }

    public static String getTextFromAttributeOrNestedElement(Element element, String name, ParserContext parserContext) {
        String attr = element.getAttribute(name);
        Element childElement = DomUtils.getChildElementByTagName((Element)element, (String)name);
        if (StringUtils.hasText((String)attr) && childElement != null) {
            parserContext.getReaderContext().error("Either an attribute or a child element can be specified for " + name + " but not both", (Object)element);
            return null;
        }
        if (!StringUtils.hasText((String)attr) && childElement == null) {
            return null;
        }
        return StringUtils.hasText((String)attr) ? attr : childElement.getTextContent();
    }

    public static BeanComponentDefinition parseInnerHandlerDefinition(Element element, ParserContext parserContext) {
        String ref;
        List childElements = DomUtils.getChildElementsByTagName((Element)element, (String)"bean");
        String innerComponentDefinition = null;
        if (childElements != null && childElements.size() == 1) {
            Element beanElement = (Element)childElements.get(0);
            BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
            BeanDefinitionHolder bdHolder = delegate.parseBeanDefinitionElement(beanElement);
            bdHolder = delegate.decorateBeanDefinitionIfRequired(beanElement, bdHolder);
            BeanDefinition inDef = bdHolder.getBeanDefinition();
            innerComponentDefinition = new BeanComponentDefinition(inDef, bdHolder.getBeanName());
        }
        if (StringUtils.hasText((String)(ref = element.getAttribute(REF_ATTRIBUTE))) && innerComponentDefinition != null) {
            parserContext.getReaderContext().error("Ambiguous definition. Inner bean " + (innerComponentDefinition == null ? innerComponentDefinition : innerComponentDefinition.getBeanDefinition().getBeanClassName()) + " declaration and \"ref\" " + ref + " are not allowed together on element " + IntegrationNamespaceUtils.createElementDescription(element) + ".", parserContext.extractSource((Object)element));
        }
        return innerComponentDefinition;
    }

    public static void configureHeaderMapper(Element element, BeanDefinitionBuilder rootBuilder, ParserContext parserContext, Class<?> headerMapperClass, String replyHeaderValue) {
        String defaultMappedReplyHeadersAttributeName = "mapped-reply-headers";
        if (!StringUtils.hasText((String)replyHeaderValue)) {
            replyHeaderValue = defaultMappedReplyHeadersAttributeName;
        }
        boolean hasHeaderMapper = element.hasAttribute("header-mapper");
        boolean hasMappedRequestHeaders = element.hasAttribute("mapped-request-headers");
        boolean hasMappedReplyHeaders = element.hasAttribute(replyHeaderValue);
        if (hasHeaderMapper && (hasMappedRequestHeaders || hasMappedReplyHeaders)) {
            parserContext.getReaderContext().error("The 'header-mapper' attribute is mutually exclusive with 'mapped-request-headers' or 'mapped-reply-headers'. You can only use one or the others", (Object)element);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(rootBuilder, element, "header-mapper");
        if (hasMappedRequestHeaders || hasMappedReplyHeaders) {
            BeanDefinitionBuilder headerMapperBuilder = BeanDefinitionBuilder.genericBeanDefinition(headerMapperClass);
            if (hasMappedRequestHeaders) {
                headerMapperBuilder.addPropertyValue("requestHeaderNames", (Object)element.getAttribute("mapped-request-headers"));
            }
            if (hasMappedReplyHeaders) {
                headerMapperBuilder.addPropertyValue("replyHeaderNames", (Object)element.getAttribute(replyHeaderValue));
            }
            rootBuilder.addPropertyValue("headerMapper", (Object)headerMapperBuilder.getBeanDefinition());
        }
    }

    public static BeanDefinition configureTransactionAttributes(Element txElement) {
        BeanDefinition txDefinition = IntegrationNamespaceUtils.configureTransactionDefinition(txElement);
        BeanDefinitionBuilder attributeSourceBuilder = BeanDefinitionBuilder.genericBeanDefinition(MatchAlwaysTransactionAttributeSource.class);
        attributeSourceBuilder.addPropertyValue("transactionAttribute", (Object)txDefinition);
        BeanDefinitionBuilder txInterceptorBuilder = BeanDefinitionBuilder.genericBeanDefinition(TransactionInterceptor.class);
        txInterceptorBuilder.addPropertyReference("transactionManager", txElement.getAttribute("transaction-manager"));
        txInterceptorBuilder.addPropertyValue("transactionAttributeSource", (Object)attributeSourceBuilder.getBeanDefinition());
        return txInterceptorBuilder.getBeanDefinition();
    }

    public static BeanDefinition configureTransactionDefinition(Element txElement) {
        BeanDefinitionBuilder txDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultTransactionAttribute.class);
        txDefinitionBuilder.addPropertyValue("propagationBehaviorName", (Object)("PROPAGATION_" + txElement.getAttribute("propagation")));
        txDefinitionBuilder.addPropertyValue("isolationLevelName", (Object)("ISOLATION_" + txElement.getAttribute("isolation")));
        txDefinitionBuilder.addPropertyValue("timeout", (Object)txElement.getAttribute("timeout"));
        txDefinitionBuilder.addPropertyValue("readOnly", (Object)txElement.getAttribute("read-only"));
        return txDefinitionBuilder.getBeanDefinition();
    }

    public static String[] generateAlias(Element element) {
        String[] handlerAlias = null;
        String id = element.getAttribute("id");
        if (StringUtils.hasText((String)id)) {
            handlerAlias = new String[]{id + HANDLER_ALIAS_SUFFIX};
        }
        return handlerAlias;
    }

    public static void configureAndSetAdviceChainIfPresent(Element adviceChainElement, Element txElement, BeanDefinition parentBeanDefinition, ParserContext parserContext) {
        IntegrationNamespaceUtils.configureAndSetAdviceChainIfPresent(adviceChainElement, txElement, parentBeanDefinition, parserContext, "adviceChain");
    }

    public static void configureAndSetAdviceChainIfPresent(Element adviceChainElement, Element txElement, BeanDefinition parentBeanDefinition, ParserContext parserContext, String propertyName) {
        ManagedList adviceChain = IntegrationNamespaceUtils.configureAdviceChain(adviceChainElement, txElement, parentBeanDefinition, parserContext);
        if (adviceChain != null) {
            parentBeanDefinition.getPropertyValues().add(propertyName, (Object)adviceChain);
        }
    }

    public static ManagedList configureAdviceChain(Element adviceChainElement, Element txElement, BeanDefinition parentBeanDefinition, ParserContext parserContext) {
        ManagedList adviceChain = null;
        if (txElement != null) {
            adviceChain = new ManagedList();
            adviceChain.add((Object)IntegrationNamespaceUtils.configureTransactionAttributes(txElement));
        }
        if (adviceChainElement != null) {
            adviceChain = new ManagedList();
            NodeList childNodes = adviceChainElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1) continue;
                Element childElement = (Element)child;
                String localName = child.getLocalName();
                if ("bean".equals(localName)) {
                    BeanDefinitionHolder holder = parserContext.getDelegate().parseBeanDefinitionElement(childElement, parentBeanDefinition);
                    parserContext.registerBeanComponent(new BeanComponentDefinition(holder));
                    adviceChain.add((Object)new RuntimeBeanReference(holder.getBeanName()));
                    continue;
                }
                if (REF_ATTRIBUTE.equals(localName)) {
                    String ref = childElement.getAttribute("bean");
                    adviceChain.add((Object)new RuntimeBeanReference(ref));
                    continue;
                }
                BeanDefinition customBeanDefinition = parserContext.getDelegate().parseCustomElement(childElement, parentBeanDefinition);
                if (customBeanDefinition == null) {
                    parserContext.getReaderContext().error("failed to parse custom element '" + localName + "'", (Object)childElement);
                }
                adviceChain.add((Object)customBeanDefinition);
            }
        }
        return adviceChain;
    }

    public static RootBeanDefinition createExpressionDefinitionFromValueOrExpression(String valueElementName, String expressionElementName, ParserContext parserContext, Element element, boolean oneRequired) {
        Assert.hasText((String)valueElementName, (String)"'valueElementName' must not be empty");
        Assert.hasText((String)expressionElementName, (String)"'expressionElementName' must no be empty");
        String valueElementValue = element.getAttribute(valueElementName);
        String expressionElementValue = element.getAttribute(expressionElementName);
        boolean hasAttributeValue = StringUtils.hasText((String)valueElementValue);
        boolean hasAttributeExpression = StringUtils.hasText((String)expressionElementValue);
        if (hasAttributeValue && hasAttributeExpression) {
            parserContext.getReaderContext().error("Only one of '" + valueElementName + "' or '" + expressionElementName + "' is allowed", (Object)element);
        }
        if (oneRequired && !hasAttributeValue && !hasAttributeExpression) {
            parserContext.getReaderContext().error("One of '" + valueElementName + "' or '" + expressionElementName + "' is required", (Object)element);
        }
        RootBeanDefinition expressionDef = null;
        if (hasAttributeValue) {
            expressionDef = new RootBeanDefinition(LiteralExpression.class);
            expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)valueElementValue);
        } else if (hasAttributeExpression) {
            expressionDef = new RootBeanDefinition(ExpressionFactoryBean.class);
            expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)expressionElementValue);
        }
        return expressionDef;
    }
}

