/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractTransformerParser;
import org.springframework.integration.transformer.MapToObjectTransformer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MapToObjectTransformerParser
extends AbstractTransformerParser {
    protected String getTransformerClassName() {
        return MapToObjectTransformer.class.getName();
    }

    protected void parseTransformer(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String ref = element.getAttribute("ref");
        String type = element.getAttribute("type");
        Assert.isTrue((!StringUtils.hasText((String)ref) || !StringUtils.hasText((String)type) ? 1 : 0) != 0, (String)("'type' and 'ref' attributes are mutually-exclusive, but both have valid values; type: " + type + "; ref:"));
        if (StringUtils.hasText((String)ref)) {
            builder.getBeanDefinition().getConstructorArgumentValues().addGenericArgumentValue((Object)ref, "java.lang.String");
        } else if (StringUtils.hasText((String)type)) {
            ClassLoader classLoader = parserContext.getReaderContext().getBeanClassLoader();
            if (classLoader == null) {
                classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            Class clazz = ClassUtils.resolveClassName((String)type, (ClassLoader)classLoader);
            builder.getBeanDefinition().getConstructorArgumentValues().addGenericArgumentValue((Object)clazz, "java.lang.Class");
        }
    }
}

