/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;

class ConversionServiceCreator
implements BeanFactoryPostProcessor {
    private final Log logger = LogFactory.getLog(this.getClass());

    ConversionServiceCreator() {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        if (!beanFactory.containsBean("integrationConversionService")) {
            if (beanFactory instanceof BeanDefinitionRegistry) {
                BeanDefinitionBuilder conversionServiceBuilder = BeanDefinitionBuilder.rootBeanDefinition(CustomConversionServiceFactoryBean.class);
                BeanDefinitionHolder beanDefinitionHolder = new BeanDefinitionHolder((BeanDefinition)conversionServiceBuilder.getBeanDefinition(), "integrationConversionService");
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)beanDefinitionHolder, (BeanDefinitionRegistry)((BeanDefinitionRegistry)beanFactory));
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"BeanFactory is not a BeanDefinitionRegistry implementation. Cannot register a default ConversionService.");
            }
        }
    }

    static class CustomConversionServiceFactoryBean
    extends ConversionServiceFactoryBean {
        CustomConversionServiceFactoryBean() {
        }

        public ConversionService getObject() {
            ConversionService service = super.getObject();
            if (service instanceof GenericConversionService) {
                ((GenericConversionService)service).removeConvertible(Object.class, Object.class);
            }
            return service;
        }
    }
}

