/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.core;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.support.TaskExecutorAdapter;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.core.AsyncMessagingOperations;
import org.springframework.integration.core.MessagePostProcessor;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.core.PollableChannel;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncMessagingTemplate
extends MessagingTemplate
implements AsyncMessagingOperations {
    private volatile AsyncTaskExecutor executor = new SimpleAsyncTaskExecutor();

    public void setExecutor(Executor executor) {
        Assert.notNull((Object)executor, (String)"executor must not be null");
        this.executor = executor instanceof AsyncTaskExecutor ? (AsyncTaskExecutor)executor : new TaskExecutorAdapter(executor);
    }

    @Override
    public Future<?> asyncSend(final Message<?> message) {
        return this.executor.submit(new Runnable(){

            public void run() {
                AsyncMessagingTemplate.this.send(message);
            }
        });
    }

    @Override
    public Future<?> asyncSend(final MessageChannel channel, final Message<?> message) {
        return this.executor.submit(new Runnable(){

            public void run() {
                AsyncMessagingTemplate.this.send(channel, message);
            }
        });
    }

    @Override
    public Future<?> asyncSend(final String channelName, final Message<?> message) {
        return this.executor.submit(new Runnable(){

            public void run() {
                AsyncMessagingTemplate.this.send(channelName, message);
            }
        });
    }

    @Override
    public Future<?> asyncConvertAndSend(final Object object) {
        return this.executor.submit(new Runnable(){

            public void run() {
                AsyncMessagingTemplate.this.convertAndSend(object);
            }
        });
    }

    @Override
    public Future<?> asyncConvertAndSend(final MessageChannel channel, final Object object) {
        return this.executor.submit(new Runnable(){

            public void run() {
                AsyncMessagingTemplate.this.convertAndSend(channel, object);
            }
        });
    }

    @Override
    public Future<?> asyncConvertAndSend(final String channelName, final Object object) {
        return this.executor.submit(new Runnable(){

            public void run() {
                AsyncMessagingTemplate.this.convertAndSend(channelName, object);
            }
        });
    }

    @Override
    public Future<Message<?>> asyncReceive() {
        return this.executor.submit(new Callable<Message<?>>(){

            @Override
            public Message<?> call() throws Exception {
                return AsyncMessagingTemplate.this.receive();
            }
        });
    }

    @Override
    public Future<Message<?>> asyncReceive(final PollableChannel channel) {
        return this.executor.submit(new Callable<Message<?>>(){

            @Override
            public Message<?> call() throws Exception {
                return AsyncMessagingTemplate.this.receive(channel);
            }
        });
    }

    @Override
    public Future<Message<?>> asyncReceive(final String channelName) {
        return this.executor.submit(new Callable<Message<?>>(){

            @Override
            public Message<?> call() throws Exception {
                return AsyncMessagingTemplate.this.receive(channelName);
            }
        });
    }

    @Override
    public <R> Future<R> asyncReceiveAndConvert() {
        return this.executor.submit(new Callable<R>(){

            @Override
            public R call() throws Exception {
                return AsyncMessagingTemplate.this.receiveAndConvert();
            }
        });
    }

    @Override
    public <R> Future<R> asyncReceiveAndConvert(final PollableChannel channel) {
        return this.executor.submit(new Callable<R>(){

            @Override
            public R call() throws Exception {
                return AsyncMessagingTemplate.this.receiveAndConvert(channel);
            }
        });
    }

    @Override
    public <R> Future<R> asyncReceiveAndConvert(final String channelName) {
        return this.executor.submit(new Callable<R>(){

            @Override
            public R call() throws Exception {
                return AsyncMessagingTemplate.this.receiveAndConvert(channelName);
            }
        });
    }

    @Override
    public Future<Message<?>> asyncSendAndReceive(final Message<?> requestMessage) {
        return this.executor.submit(new Callable<Message<?>>(){

            @Override
            public Message<?> call() throws Exception {
                return AsyncMessagingTemplate.this.sendAndReceive(requestMessage);
            }
        });
    }

    @Override
    public Future<Message<?>> asyncSendAndReceive(final MessageChannel channel, final Message<?> requestMessage) {
        return this.executor.submit(new Callable<Message<?>>(){

            @Override
            public Message<?> call() throws Exception {
                return AsyncMessagingTemplate.this.sendAndReceive(channel, requestMessage);
            }
        });
    }

    @Override
    public Future<Message<?>> asyncSendAndReceive(final String channelName, final Message<?> requestMessage) {
        return this.executor.submit(new Callable<Message<?>>(){

            @Override
            public Message<?> call() throws Exception {
                return AsyncMessagingTemplate.this.sendAndReceive(channelName, requestMessage);
            }
        });
    }

    @Override
    public <R> Future<R> asyncConvertSendAndReceive(final Object request) {
        return this.executor.submit(new Callable<R>(){

            @Override
            public R call() throws Exception {
                return AsyncMessagingTemplate.this.convertSendAndReceive(request);
            }
        });
    }

    @Override
    public <R> Future<R> asyncConvertSendAndReceive(final MessageChannel channel, final Object request) {
        return this.executor.submit(new Callable<R>(){

            @Override
            public R call() throws Exception {
                return AsyncMessagingTemplate.this.convertSendAndReceive(channel, request);
            }
        });
    }

    @Override
    public <R> Future<R> asyncConvertSendAndReceive(final String channelName, final Object request) {
        return this.executor.submit(new Callable<R>(){

            @Override
            public R call() throws Exception {
                return AsyncMessagingTemplate.this.convertSendAndReceive(channelName, request);
            }
        });
    }

    @Override
    public <R> Future<R> asyncConvertSendAndReceive(final Object request, final MessagePostProcessor requestPostProcessor) {
        return this.executor.submit(new Callable<R>(){

            @Override
            public R call() throws Exception {
                return AsyncMessagingTemplate.this.convertSendAndReceive(request, requestPostProcessor);
            }
        });
    }

    @Override
    public <R> Future<R> asyncConvertSendAndReceive(final MessageChannel channel, final Object request, final MessagePostProcessor requestPostProcessor) {
        return this.executor.submit(new Callable<R>(){

            @Override
            public R call() throws Exception {
                return AsyncMessagingTemplate.this.convertSendAndReceive(channel, request, requestPostProcessor);
            }
        });
    }

    @Override
    public <R> Future<R> asyncConvertSendAndReceive(final String channelName, final Object request, final MessagePostProcessor requestPostProcessor) {
        return this.executor.submit(new Callable<R>(){

            @Override
            public R call() throws Exception {
                return AsyncMessagingTemplate.this.convertSendAndReceive(channelName, request, requestPostProcessor);
            }
        });
    }
}

