/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.Expression;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageSource<T>
extends AbstractExpressionEvaluator
implements MessageSource<T> {
    private volatile Map<String, Expression> headerExpressions = Collections.emptyMap();

    public void setHeaderExpressions(Map<String, Expression> headerExpressions) {
        this.headerExpressions = headerExpressions != null ? headerExpressions : Collections.emptyMap();
    }

    @Override
    public final Message<T> receive() {
        Message<Object> message = null;
        Object result = this.doReceive();
        Map<String, Object> headers = this.evaluateHeaders();
        if (result instanceof Message) {
            try {
                message = (Message<Object>)result;
            }
            catch (Exception e) {
                throw new MessagingException("MessageSource returned unexpected type.", (Throwable)e);
            }
            if (!CollectionUtils.isEmpty(headers)) {
                MessageBuilder builder = MessageBuilder.fromMessage(message);
                builder.copyHeaders(headers);
                message = builder.build();
            }
        } else if (result != null) {
            Object payload = null;
            try {
                payload = result;
            }
            catch (Exception e) {
                throw new MessagingException("MessageSource returned unexpected type.", (Throwable)e);
            }
            MessageBuilder<Object> builder = MessageBuilder.withPayload(payload);
            if (!CollectionUtils.isEmpty(headers)) {
                builder.copyHeaders(headers);
            }
            message = builder.build();
        }
        return message;
    }

    private Map<String, Object> evaluateHeaders() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Map.Entry<String, Expression> entry : this.headerExpressions.entrySet()) {
            Object headerValue = this.evaluateExpression(entry.getValue());
            if (headerValue == null) continue;
            results.put(entry.getKey(), headerValue);
        }
        return results;
    }

    protected abstract Object doReceive();
}

