/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import org.springframework.integration.Message;
import org.springframework.integration.endpoint.AbstractPollingEndpoint;
import org.springframework.integration.transaction.IntegrationResourceHolder;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTransactionSynchronizingPollingEndpoint
extends AbstractPollingEndpoint {
    private volatile TransactionSynchronizationFactory transactionSynchronizationFactory;

    AbstractTransactionSynchronizingPollingEndpoint() {
    }

    public void setTransactionSynchronizationFactory(TransactionSynchronizationFactory transactionSynchronizationFactory) {
        this.transactionSynchronizationFactory = transactionSynchronizationFactory;
    }

    protected Object getResourceToBind() {
        return null;
    }

    protected String getResourceKey() {
        return null;
    }

    @Override
    protected final boolean doPoll() {
        boolean result;
        IntegrationResourceHolder holder = this.bindResourceHolderIfNecessary(this.getResourceKey(), this.getResourceToBind());
        Message<?> message = this.receiveMessage();
        if (message == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Received no Message during the poll, returning 'false'");
            }
            result = false;
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Poll resulted in Message: " + message));
            }
            if (holder != null) {
                holder.setMessage(message);
            }
            this.handleMessage(message);
            result = true;
        }
        return result;
    }

    private IntegrationResourceHolder bindResourceHolderIfNecessary(String key, Object resource) {
        IntegrationResourceHolder holder = null;
        if (this.transactionSynchronizationFactory != null && resource != null && TransactionSynchronizationManager.isActualTransactionActive()) {
            holder = new IntegrationResourceHolder();
            if (key != null) {
                holder.addAttribute(key, resource);
            }
            TransactionSynchronizationManager.bindResource((Object)resource, (Object)holder);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this.transactionSynchronizationFactory.create(resource));
        }
        return holder;
    }

    @Override
    protected abstract Message<?> receiveMessage();

    @Override
    protected abstract void handleMessage(Message<?> var1);
}

