/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessagingException;
import org.springframework.integration.context.NamedComponent;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.endpoint.AbstractTransactionSynchronizingPollingEndpoint;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.history.TrackableComponent;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourcePollingChannelAdapter
extends AbstractTransactionSynchronizingPollingEndpoint
implements TrackableComponent {
    private volatile MessageSource<?> source;
    private volatile MessageChannel outputChannel;
    private volatile boolean shouldTrack;
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();

    public void setSource(MessageSource<?> source) {
        this.source = source;
    }

    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setSendTimeout(long sendTimeout) {
        this.messagingTemplate.setSendTimeout(sendTimeout);
    }

    @Override
    public void setShouldTrack(boolean shouldTrack) {
        this.shouldTrack = shouldTrack;
    }

    @Override
    public String getComponentType() {
        return this.source instanceof NamedComponent ? ((NamedComponent)((Object)this.source)).getComponentType() : "inbound-channel-adapter";
    }

    @Override
    protected void onInit() {
        Assert.notNull(this.source, (String)"source must not be null");
        Assert.notNull((Object)this.outputChannel, (String)"outputChannel must not be null");
        super.onInit();
    }

    @Override
    protected void handleMessage(Message<?> message) {
        if (this.shouldTrack) {
            message = MessageHistory.write(message, this);
        }
        try {
            this.messagingTemplate.send(this.outputChannel, message);
        }
        catch (Exception e) {
            if (e instanceof MessagingException) {
                throw (MessagingException)e;
            }
            throw new MessagingException(message, (Throwable)e);
        }
    }

    @Override
    protected Message<?> receiveMessage() {
        return this.source.receive();
    }

    @Override
    protected Object getResourceToBind() {
        return this.source;
    }

    @Override
    protected String getResourceKey() {
        return "messageSource";
    }
}

