/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.expression;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.integration.context.IntegrationContextUtils;

public abstract class ExpressionUtils {
    public static StandardEvaluationContext createStandardEvaluationContext() {
        return ExpressionUtils.createStandardEvaluationContext(null, null);
    }

    public static StandardEvaluationContext createStandardEvaluationContext(BeanResolver beanResolver) {
        return ExpressionUtils.createStandardEvaluationContext(beanResolver, null);
    }

    public static StandardEvaluationContext createStandardEvaluationContext(ConversionService conversionService) {
        return ExpressionUtils.createStandardEvaluationContext(null, conversionService);
    }

    public static StandardEvaluationContext createStandardEvaluationContext(BeanResolver beanResolver, ConversionService conversionService) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        if (beanResolver != null) {
            evaluationContext.setBeanResolver(beanResolver);
        }
        if (conversionService != null) {
            evaluationContext.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
        }
        return evaluationContext;
    }

    public static StandardEvaluationContext createStandardEvaluationContext(BeanFactory beanFactory) {
        ConversionService conversionService = IntegrationContextUtils.getConversionService(beanFactory);
        if (conversionService == null && beanFactory instanceof ConfigurableListableBeanFactory) {
            conversionService = ((ConfigurableListableBeanFactory)beanFactory).getConversionService();
        }
        return ExpressionUtils.createStandardEvaluationContext((BeanResolver)new BeanFactoryResolver(beanFactory), conversionService);
    }
}

