/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.util.List;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.MessageHeaders;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.ReplyRequiredException;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.support.channel.ChannelResolutionException;
import org.springframework.integration.support.channel.ChannelResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReplyProducingMessageHandler
extends AbstractMessageHandler
implements MessageProducer,
BeanClassLoaderAware {
    private MessageChannel outputChannel;
    private volatile boolean requiresReply = false;
    private final MessagingTemplate messagingTemplate;
    private volatile RequestHandler advisedRequestHandler;
    private volatile List<Advice> adviceChain;
    private volatile ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public AbstractReplyProducingMessageHandler() {
        this.messagingTemplate = new MessagingTemplate();
    }

    @Override
    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setSendTimeout(long sendTimeout) {
        this.messagingTemplate.setSendTimeout(sendTimeout);
    }

    public void setChannelResolver(ChannelResolver channelResolver) {
        Assert.notNull((Object)channelResolver, (String)"'channelResolver' must not be null");
        this.messagingTemplate.setChannelResolver(channelResolver);
    }

    public void setRequiresReply(boolean requiresReply) {
        this.requiresReply = requiresReply;
    }

    protected MessagingTemplate getMessagingTemplate() {
        return this.messagingTemplate;
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        Assert.notNull(adviceChain, (String)"adviceChain cannot be null");
        this.adviceChain = adviceChain;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Override
    protected void onInit() {
        if (this.getBeanFactory() != null) {
            this.messagingTemplate.setBeanFactory(this.getBeanFactory());
        }
        if (!CollectionUtils.isEmpty(this.adviceChain)) {
            ProxyFactory proxyFactory = new ProxyFactory((Object)new AdvisedRequestHandler());
            for (Advice advice : this.adviceChain) {
                proxyFactory.addAdvice(advice);
            }
            this.advisedRequestHandler = (RequestHandler)proxyFactory.getProxy(this.beanClassLoader);
        }
    }

    @Override
    protected final void handleMessageInternal(Message<?> message) {
        Object result = this.advisedRequestHandler == null ? this.handleRequestMessage(message) : this.advisedRequestHandler.handleRequestMessage(message);
        if (result != null) {
            MessageHeaders requestHeaders = message.getHeaders();
            this.handleResult(result, requestHeaders);
        } else {
            if (this.requiresReply) {
                throw new ReplyRequiredException(message, "No reply produced by handler '" + this.getComponentName() + "', and its 'requiresReply' property is set to true.");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("handler '" + this + "' produced no reply for request Message: " + message));
            }
        }
    }

    private void handleResult(Object result, MessageHeaders requestHeaders) {
        if (result instanceof Iterable && this.shouldSplitReply((Iterable)result)) {
            for (Object o : (Iterable)result) {
                this.produceReply(o, requestHeaders);
            }
        } else if (result != null) {
            this.produceReply(result, requestHeaders);
        }
    }

    private void produceReply(Object reply, MessageHeaders requestHeaders) {
        Message<?> replyMessage = this.createReplyMessage(reply, requestHeaders);
        this.sendReplyMessage(replyMessage, requestHeaders.getReplyChannel());
    }

    private Message<?> createReplyMessage(Object reply, MessageHeaders requestHeaders) {
        MessageBuilder<Object> builder = null;
        if (reply instanceof Message) {
            if (!this.shouldCopyRequestHeaders()) {
                return (Message)reply;
            }
            builder = MessageBuilder.fromMessage((Message)reply);
        } else {
            builder = reply instanceof MessageBuilder ? (MessageBuilder<Object>)reply : MessageBuilder.withPayload(reply);
        }
        if (this.shouldCopyRequestHeaders()) {
            builder.copyHeadersIfAbsent(requestHeaders);
        }
        return builder.build();
    }

    private final void sendReplyMessage(Message<?> replyMessage, Object replyChannelHeaderValue) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("handler '" + this + "' sending reply Message: " + replyMessage));
        }
        if (this.outputChannel != null) {
            this.sendMessage(replyMessage, this.outputChannel);
        } else if (replyChannelHeaderValue != null) {
            this.sendMessage(replyMessage, replyChannelHeaderValue);
        } else {
            throw new ChannelResolutionException("no output-channel or replyChannel header available");
        }
    }

    private void sendMessage(Message<?> message, Object channel) {
        if (channel instanceof MessageChannel) {
            this.messagingTemplate.send((MessageChannel)channel, message);
        } else if (channel instanceof String) {
            this.messagingTemplate.send((String)channel, message);
        } else {
            throw new MessageDeliveryException(message, "a non-null reply channel value of type MessageChannel or String is required");
        }
    }

    private boolean shouldSplitReply(Iterable<?> reply) {
        for (Object next : reply) {
            if (!(next instanceof Message) && !(next instanceof MessageBuilder)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldCopyRequestHeaders() {
        return true;
    }

    protected abstract Object handleRequestMessage(Message<?> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AdvisedRequestHandler
    implements RequestHandler {
        private AdvisedRequestHandler() {
        }

        @Override
        public Object handleRequestMessage(Message<?> requestMessage) {
            return AbstractReplyProducingMessageHandler.this.handleRequestMessage(requestMessage);
        }

        @Override
        public String toString() {
            return AbstractReplyProducingMessageHandler.this.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RequestHandler {
        public Object handleRequestMessage(Message<?> var1);

        public String toString();
    }
}

