/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.Message;
import org.springframework.integration.dispatcher.AggregateMessageDeliveryException;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingHandler
extends AbstractMessageHandler {
    private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private volatile Expression expression;
    private final Level level;
    private final EvaluationContext evaluationContext;
    private volatile Log messageLogger;

    public LoggingHandler(String level) {
        this.messageLogger = this.logger;
        try {
            this.level = Level.valueOf(level.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid log level '" + level + "'. The (case-insensitive) supported values are: " + StringUtils.arrayToCommaDelimitedString((Object[])Level.values()));
        }
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        this.evaluationContext = evaluationContext;
        this.expression = EXPRESSION_PARSER.parseExpression("payload");
    }

    public void setExpression(String expressionString) {
        this.expression = EXPRESSION_PARSER.parseExpression(expressionString);
    }

    public void setLoggerName(String loggerName) {
        Assert.hasText((String)loggerName, (String)"loggerName must not be empty");
        this.messageLogger = LogFactory.getLog((String)loggerName);
    }

    public void setShouldLogFullMessage(boolean shouldLogFullMessage) {
        this.expression = shouldLogFullMessage ? EXPRESSION_PARSER.parseExpression("#root") : EXPRESSION_PARSER.parseExpression("payload");
    }

    @Override
    public String getComponentType() {
        return "logging-channel-adapter";
    }

    @Override
    protected void handleMessageInternal(Message<?> message) throws Exception {
        Object logMessage = this.expression.getValue(this.evaluationContext, message);
        if (logMessage instanceof Throwable) {
            StringWriter stringWriter = new StringWriter();
            if (logMessage instanceof AggregateMessageDeliveryException) {
                stringWriter.append(((Throwable)logMessage).getMessage());
                for (Exception exception : ((AggregateMessageDeliveryException)logMessage).getAggregatedExceptions()) {
                    exception.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                }
            } else {
                ((Throwable)logMessage).printStackTrace(new PrintWriter((Writer)stringWriter, true));
            }
            logMessage = stringWriter.toString();
        }
        switch (this.level) {
            case FATAL: {
                if (!this.messageLogger.isFatalEnabled()) break;
                this.messageLogger.fatal(logMessage);
                break;
            }
            case ERROR: {
                if (!this.messageLogger.isErrorEnabled()) break;
                this.messageLogger.error(logMessage);
                break;
            }
            case WARN: {
                if (!this.messageLogger.isWarnEnabled()) break;
                this.messageLogger.warn(logMessage);
                break;
            }
            case INFO: {
                if (!this.messageLogger.isInfoEnabled()) break;
                this.messageLogger.info(logMessage);
                break;
            }
            case DEBUG: {
                if (!this.messageLogger.isDebugEnabled()) break;
                this.messageLogger.debug(logMessage);
                break;
            }
            case TRACE: {
                if (!this.messageLogger.isTraceEnabled()) break;
                this.messageLogger.trace(logMessage);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

