/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.lang.reflect.Method;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.handler.AbstractMessageProcessor;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.handler.MethodInvokingMessageProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceActivatingHandler
extends AbstractReplyProducingMessageHandler {
    private final MessageProcessor<?> processor;

    public ServiceActivatingHandler(Object object) {
        this(new MethodInvokingMessageProcessor(object, ServiceActivator.class));
    }

    public ServiceActivatingHandler(Object object, Method method) {
        this(new MethodInvokingMessageProcessor(object, method));
    }

    public ServiceActivatingHandler(Object object, String methodName) {
        this(new MethodInvokingMessageProcessor(object, methodName));
    }

    public <T> ServiceActivatingHandler(MessageProcessor<T> processor) {
        this.processor = processor;
    }

    @Override
    public String getComponentType() {
        return "service-activator";
    }

    @Override
    public final void onInit() {
        super.onInit();
        if (this.processor instanceof AbstractMessageProcessor) {
            ((AbstractMessageProcessor)this.processor).setConversionService(this.getConversionService());
        }
    }

    @Override
    protected Object handleRequestMessage(Message<?> message) {
        try {
            return this.processor.processMessage(message);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new MessageHandlingException(message, "failure occurred in Service Activator '" + this + "'", e);
        }
    }

    @Override
    public String toString() {
        return "ServiceActivator for [" + this.processor + "]";
    }
}

