/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mapping;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.MessageHeaders;
import org.springframework.integration.mapping.RequestReplyHeaderMapper;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHeaderMapper<T>
implements RequestReplyHeaderMapper<T> {
    public static final String STANDARD_REQUEST_HEADER_NAME_PATTERN = "STANDARD_REQUEST_HEADERS";
    public static final String STANDARD_REPLY_HEADER_NAME_PATTERN = "STANDARD_REPLY_HEADERS";
    private static final String[] TRANSIENT_HEADER_NAMES = new String[]{"id", "errorChannel", "replyChannel", "timestamp"};
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final String standardHeaderPrefix;
    private volatile String userDefinedHeaderPrefix = "";
    private volatile List<String> requestHeaderNames = new ArrayList<String>();
    private volatile List<String> replyHeaderNames = new ArrayList<String>();

    protected AbstractHeaderMapper() {
        this.standardHeaderPrefix = this.getStandardHeaderPrefix();
        this.requestHeaderNames.addAll(this.getStandardRequestHeaderNames());
        this.replyHeaderNames.addAll(this.getStandardReplyHeaderNames());
    }

    public void setRequestHeaderNames(String[] requestHeaderNames) {
        Assert.notNull((Object)requestHeaderNames, (String)"'requestHeaderNames' must not be null");
        this.requestHeaderNames = Arrays.asList(requestHeaderNames);
    }

    public void setReplyHeaderNames(String[] replyHeaderNames) {
        Assert.notNull((Object)replyHeaderNames, (String)"'replyHeaderNames' must not be null");
        this.replyHeaderNames = Arrays.asList(replyHeaderNames);
    }

    public void setUserDefinedHeaderPrefix(String userDefinedHeaderPrefix) {
        this.userDefinedHeaderPrefix = userDefinedHeaderPrefix != null ? userDefinedHeaderPrefix : "";
    }

    @Override
    public void fromHeadersToRequest(MessageHeaders headers, T target) {
        this.fromHeaders(headers, target, this.requestHeaderNames);
    }

    @Override
    public void fromHeadersToReply(MessageHeaders headers, T target) {
        this.fromHeaders(headers, target, this.replyHeaderNames);
    }

    @Override
    public Map<String, Object> toHeadersFromRequest(T source) {
        return this.toHeaders(source, this.requestHeaderNames);
    }

    @Override
    public Map<String, Object> toHeadersFromReply(T source) {
        return this.toHeaders(source, this.replyHeaderNames);
    }

    private void fromHeaders(MessageHeaders headers, T target, List<String> headerPatterns) {
        block3: {
            try {
                HashMap<String, Object> subset = new HashMap<String, Object>();
                for (String headerName : headers.keySet()) {
                    if (!this.shouldMapHeader(headerName, headerPatterns)) continue;
                    subset.put(headerName, headers.get(headerName));
                }
                this.populateStandardHeaders(subset, target);
                this.populateUserDefinedHeaders(subset, target);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block3;
                this.logger.warn((Object)"error occurred while mapping from MessageHeaders", (Throwable)e);
            }
        }
    }

    private void populateUserDefinedHeaders(Map<String, Object> headers, T target) {
        for (String headerName : headers.keySet()) {
            Object value = headers.get(headerName);
            if (value == null) continue;
            try {
                if (headerName.startsWith(this.standardHeaderPrefix)) continue;
                String key = this.addPrefixIfNecessary(this.userDefinedHeaderPrefix, headerName);
                this.populateUserDefinedHeader(key, value, target);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("failed to map from Message header '" + headerName + "' to target"), (Throwable)e);
            }
        }
    }

    private Map<String, Object> toHeaders(T source, List<String> headerPatterns) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        Map<String, Object> standardHeaders = this.extractStandardHeaders(source);
        this.copyHeaders(this.standardHeaderPrefix, standardHeaders, headers, headerPatterns);
        Map<String, Object> userDefinedHeaders = this.extractUserDefinedHeaders(source);
        this.copyHeaders(this.userDefinedHeaderPrefix, userDefinedHeaders, headers, headerPatterns);
        return headers;
    }

    private <V> void copyHeaders(String prefix, Map<String, Object> source, Map<String, Object> target, List<String> headerPatterns) {
        if (!CollectionUtils.isEmpty(source)) {
            for (Map.Entry<String, Object> entry : source.entrySet()) {
                try {
                    String headerName = this.addPrefixIfNecessary(prefix, entry.getKey());
                    if (!this.shouldMapHeader(headerName, headerPatterns)) continue;
                    target.put(headerName, entry.getValue());
                }
                catch (Exception e) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn((Object)("error occurred while mapping header '" + entry.getKey() + "' to Message header"), (Throwable)e);
                }
            }
        }
    }

    private boolean shouldMapHeader(String headerName, List<String> patterns) {
        if (!StringUtils.hasText((String)headerName) || ObjectUtils.containsElement((Object[])TRANSIENT_HEADER_NAMES, (Object)headerName)) {
            return false;
        }
        if (patterns != null && patterns.size() > 0) {
            for (String pattern : patterns) {
                if (PatternMatchUtils.simpleMatch((String)pattern.toLowerCase(), (String)headerName.toLowerCase())) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
                    }
                    return true;
                }
                if (STANDARD_REQUEST_HEADER_NAME_PATTERN.equals(pattern) && this.containsElementIgnoreCase(this.getStandardRequestHeaderNames(), headerName)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
                    }
                    return true;
                }
                if (!STANDARD_REPLY_HEADER_NAME_PATTERN.equals(pattern) || !this.containsElementIgnoreCase(this.getStandardReplyHeaderNames(), headerName)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
                }
                return true;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL NOT be mapped", headerName));
        }
        return false;
    }

    protected <V> V getHeaderIfAvailable(Map<String, Object> headers, String name, Class<V> type) {
        Object value = headers.get(name);
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("skipping header '" + name + "' since it is not of expected type [" + type + "], it is [" + value.getClass() + "]"));
            }
            return null;
        }
        return (V)value;
    }

    private boolean containsElementIgnoreCase(List<String> headerNames, String name) {
        for (String headerName : headerNames) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private String addPrefixIfNecessary(String prefix, String propertyName) {
        String headerName = propertyName;
        if (StringUtils.hasText((String)prefix) && !headerName.startsWith(prefix) && !headerName.equals("content-type")) {
            headerName = prefix + propertyName;
        }
        return headerName;
    }

    protected List<String> getStandardReplyHeaderNames() {
        return Collections.emptyList();
    }

    protected List<String> getStandardRequestHeaderNames() {
        return Collections.emptyList();
    }

    protected abstract String getStandardHeaderPrefix();

    protected abstract Map<String, Object> extractStandardHeaders(T var1);

    protected abstract Map<String, Object> extractUserDefinedHeaders(T var1);

    protected abstract void populateStandardHeaders(Map<String, Object> var1, T var2);

    protected abstract void populateUserDefinedHeader(String var1, Object var2, T var3);
}

