/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessagingException;
import org.springframework.integration.router.AbstractMessageRouter;
import org.springframework.integration.router.MappingMessageRouterManagement;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.support.channel.ChannelResolutionException;
import org.springframework.integration.support.channel.ChannelResolver;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingMessageRouter
extends AbstractMessageRouter
implements MappingMessageRouterManagement {
    private volatile Map<String, String> channelMappings = new ConcurrentHashMap<String, String>();
    private volatile ChannelResolver channelResolver;
    private volatile String prefix;
    private volatile String suffix;
    private volatile boolean resolutionRequired = true;

    public void setChannelMappings(Map<String, String> channelMappings) {
        Map<String, String> oldChannelMappings = this.channelMappings;
        ConcurrentHashMap<String, String> newChannelMappings = new ConcurrentHashMap<String, String>();
        newChannelMappings.putAll(channelMappings);
        this.channelMappings = newChannelMappings;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Channel mappings:" + oldChannelMappings + " replaced with:" + newChannelMappings));
        }
    }

    public void setChannelResolver(ChannelResolver channelResolver) {
        Assert.notNull((Object)channelResolver, (String)"'channelResolver' must not be null");
        this.channelResolver = channelResolver;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setResolutionRequired(boolean resolutionRequired) {
        this.resolutionRequired = resolutionRequired;
    }

    protected Map<String, String> getChannelMappings() {
        return Collections.unmodifiableMap(this.channelMappings);
    }

    @Override
    @ManagedOperation
    public void setChannelMapping(String key, String channelName) {
        this.channelMappings.put(key, channelName);
    }

    @Override
    @ManagedOperation
    public void removeChannelMapping(String key) {
        this.channelMappings.remove(key);
    }

    @Override
    public void onInit() {
        BeanFactory beanFactory = this.getBeanFactory();
        if (this.channelResolver == null && beanFactory != null) {
            this.channelResolver = new BeanFactoryChannelResolver(beanFactory);
        }
    }

    protected abstract List<Object> getChannelKeys(Message<?> var1);

    @Override
    protected Collection<MessageChannel> determineTargetChannels(Message<?> message) {
        ArrayList<MessageChannel> channels = new ArrayList<MessageChannel>();
        List<Object> channelKeys = this.getChannelKeys(message);
        this.addToCollection(channels, channelKeys, message);
        return channels;
    }

    private MessageChannel resolveChannelForName(String channelName, Message<?> message) {
        MessageChannel channel;
        block4: {
            if (this.channelResolver == null) {
                this.onInit();
            }
            Assert.state((this.channelResolver != null ? 1 : 0) != 0, (String)"unable to resolve channel names, no ChannelResolver available");
            channel = null;
            try {
                channel = this.channelResolver.resolveChannelName(channelName);
            }
            catch (ChannelResolutionException e) {
                if (!this.resolutionRequired) break block4;
                throw new MessagingException(message, "failed to resolve channel name '" + channelName + "'", e);
            }
        }
        if (channel == null && this.resolutionRequired) {
            throw new MessagingException(message, "failed to resolve channel name '" + channelName + "'");
        }
        return channel;
    }

    private void addChannelFromString(Collection<MessageChannel> channels, String channelKey, Message<?> message) {
        MessageChannel channel;
        if (channelKey.indexOf(44) != -1) {
            for (String name : StringUtils.tokenizeToStringArray((String)channelKey, (String)",")) {
                this.addChannelFromString(channels, name, message);
            }
            return;
        }
        String channelName = channelKey;
        if (this.channelMappings.containsKey(channelKey)) {
            channelName = this.channelMappings.get(channelKey);
        }
        if (this.prefix != null) {
            channelName = this.prefix + channelName;
        }
        if (this.suffix != null) {
            channelName = channelName + this.suffix;
        }
        if ((channel = this.resolveChannelForName(channelName, message)) != null) {
            channels.add(channel);
        }
    }

    private void addToCollection(Collection<MessageChannel> channels, Collection<?> channelKeys, Message<?> message) {
        if (channelKeys == null) {
            return;
        }
        for (Object channelKey : channelKeys) {
            if (channelKey == null) continue;
            if (channelKey instanceof MessageChannel) {
                channels.add((MessageChannel)channelKey);
                continue;
            }
            if (channelKey instanceof MessageChannel[]) {
                channels.addAll(Arrays.asList((MessageChannel[])channelKey));
                continue;
            }
            if (channelKey instanceof String) {
                this.addChannelFromString(channels, (String)channelKey, message);
                continue;
            }
            if (channelKey instanceof String[]) {
                for (String indicatorName : (String[])channelKey) {
                    this.addChannelFromString(channels, indicatorName, message);
                }
                continue;
            }
            if (channelKey instanceof Collection) {
                this.addToCollection(channels, (Collection)channelKey, message);
                continue;
            }
            if (this.getRequiredConversionService().canConvert(channelKey.getClass(), String.class)) {
                this.addChannelFromString(channels, (String)this.getConversionService().convert(channelKey, String.class), message);
                continue;
            }
            throw new MessagingException("unsupported return type for router [" + channelKey.getClass() + "]");
        }
    }
}

