/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.Collections;
import java.util.List;
import org.springframework.integration.Message;
import org.springframework.integration.router.AbstractMappingMessageRouter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderValueRouter
extends AbstractMappingMessageRouter {
    private final String headerName;

    public HeaderValueRouter(String headerName) {
        Assert.notNull((Object)headerName, (String)"'headerName' must not be null");
        this.headerName = headerName;
    }

    @Override
    protected List<Object> getChannelKeys(Message<?> message) {
        String[] value = message.getHeaders().get(this.headerName);
        if (value instanceof String && ((String)value).indexOf(44) != -1) {
            value = StringUtils.tokenizeToStringArray((String)((String)value), (String)",", (boolean)true, (boolean)true);
        }
        return Collections.singletonList(value);
    }
}

