/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scheduling;

import java.util.List;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollerMetadata {
    public static final int MAX_MESSAGES_UNBOUNDED = Integer.MIN_VALUE;
    public static final String DEFAULT_POLLER_METADATA_BEAN_NAME = "org.springframework.integration.context.defaultPollerMetadata";
    private volatile Trigger trigger;
    private volatile long maxMessagesPerPoll = Integer.MIN_VALUE;
    private volatile long receiveTimeout = 1000L;
    private volatile ErrorHandler errorHandler;
    private volatile List<Advice> adviceChain;
    private volatile Executor taskExecutor;
    private volatile long sendTimeout;
    private volatile TransactionSynchronizationFactory transactionSynchronizationFactory;

    public void setTransactionSynchronizationFactory(TransactionSynchronizationFactory transactionSynchronizationFactory) {
        Assert.notNull((Object)transactionSynchronizationFactory, (String)"'transactionSynchronizationFactory' must not be null");
        this.transactionSynchronizationFactory = transactionSynchronizationFactory;
    }

    public TransactionSynchronizationFactory getTransactionSynchronizationFactory() {
        return this.transactionSynchronizationFactory;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setMaxMessagesPerPoll(long maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public long getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        this.adviceChain = adviceChain;
    }

    public List<Advice> getAdviceChain() {
        return this.adviceChain;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public Executor getTaskExecutor() {
        return this.taskExecutor;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public static PollerMetadata getDefaultPollerMetadata(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        if (!beanFactory.containsBean(DEFAULT_POLLER_METADATA_BEAN_NAME)) {
            return null;
        }
        return (PollerMetadata)beanFactory.getBean(DEFAULT_POLLER_METADATA_BEAN_NAME, PollerMetadata.class);
    }
}

