/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splitter;

import java.util.Collection;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.integration.Message;
import org.springframework.integration.handler.AbstractMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMessageProcessingSplitter
extends AbstractMessageSplitter {
    private final MessageProcessor<Collection<?>> messageProcessor;

    protected AbstractMessageProcessingSplitter(MessageProcessor<Collection<?>> expressionEvaluatingMessageProcessor) {
        Assert.notNull(expressionEvaluatingMessageProcessor, (String)"messageProcessor must not be null");
        this.messageProcessor = expressionEvaluatingMessageProcessor;
    }

    @Override
    public void onInit() {
        super.onInit();
        ConversionService conversionService = this.getConversionService();
        if (conversionService != null && this.messageProcessor instanceof AbstractMessageProcessor) {
            ((AbstractMessageProcessor)this.messageProcessor).setConversionService(conversionService);
        }
        if (this.messageProcessor instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.messageProcessor).setBeanFactory(this.getBeanFactory());
        }
    }

    @Override
    protected final Object splitMessage(Message<?> message) {
        return this.messageProcessor.processMessage(message);
    }
}

