/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.store;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.springframework.integration.Message;
import org.springframework.integration.store.MessageGroup;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageGroupMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Object groupId;
    private final List<UUID> messageIds = new LinkedList<UUID>();
    private final boolean complete;
    private final long timestamp;
    private volatile long lastModified;
    private final int lastReleasedMessageSequenceNumber;

    public MessageGroupMetadata(MessageGroup messageGroup) {
        Assert.notNull((Object)messageGroup, (String)"'messageGroup' must not be null");
        this.groupId = messageGroup.getGroupId();
        for (Message<?> message : messageGroup.getMessages()) {
            this.messageIds.add(message.getHeaders().getId());
        }
        this.complete = messageGroup.isComplete();
        this.timestamp = messageGroup.getTimestamp();
        this.lastReleasedMessageSequenceNumber = messageGroup.getLastReleasedMessageSequenceNumber();
        this.lastModified = messageGroup.getLastModified();
    }

    public void remove(UUID messageId) {
        this.messageIds.remove(messageId);
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public Object getGroupId() {
        return this.groupId;
    }

    public Iterator<UUID> messageIdIterator() {
        return this.messageIds.iterator();
    }

    public int size() {
        return this.messageIds.size();
    }

    public UUID firstId() {
        if (this.messageIds.size() > 0) {
            return this.messageIds.iterator().next();
        }
        return null;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getLastReleasedMessageSequenceNumber() {
        return this.lastReleasedMessageSequenceNumber;
    }
}

