/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.store.MetadataStore;
import org.springframework.util.Assert;
import org.springframework.util.DefaultPropertiesPersister;

public class PropertiesPersistingMetadataStore
implements MetadataStore,
InitializingBean,
DisposableBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Properties metadata = new Properties();
    private final DefaultPropertiesPersister persister = new DefaultPropertiesPersister();
    private volatile File file;
    private volatile String baseDirectory = System.getProperty("java.io.tmpdir") + "/spring-integration/";

    public void setBaseDirectory(String baseDirectory) {
        Assert.hasText((String)baseDirectory, (String)"'baseDirectory' must be non-empty");
        this.baseDirectory = baseDirectory;
    }

    public void afterPropertiesSet() throws Exception {
        File baseDir = new File(this.baseDirectory);
        baseDir.mkdirs();
        this.file = new File(baseDir, "metadata-store.properties");
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create metadata-store file '" + this.file.getAbsolutePath() + "'", e);
        }
        this.loadMetadata();
    }

    public void put(String key, String value) {
        this.metadata.setProperty(key, value);
    }

    public String get(String key) {
        return this.metadata.getProperty(key);
    }

    public void destroy() throws Exception {
        this.saveMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMetadata() {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(this.file);
            this.persister.store(this.metadata, (OutputStream)outputStream, "Last feed entry");
        }
        catch (IOException e) {
            this.logger.warn((Object)"Failed to persist feed entry. This may result in a duplicate feed entry after this component is restarted.", (Throwable)e);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                this.logger.warn((Object)("Failed to close FileOutputStream to " + this.file.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetadata() {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.file);
            this.persister.load(this.metadata, (InputStream)inputStream);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Failed to load feed entry from the persistent store. This may result in a duplicate feed entry after this component is restarted", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e2) {
                this.logger.warn((Object)("Failed to close FileInputStream for: " + this.file.getAbsolutePath()));
            }
        }
    }
}

