/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.converter;

import org.springframework.integration.Message;
import org.springframework.integration.mapping.InboundMessageMapper;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.support.converter.MessageConversionException;
import org.springframework.integration.support.converter.MessageConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMessageConverter
implements MessageConverter {
    private volatile InboundMessageMapper inboundMessageMapper;
    private volatile OutboundMessageMapper outboundMessageMapper;

    public SimpleMessageConverter() {
        this(null, null);
    }

    public SimpleMessageConverter(InboundMessageMapper<?> inboundMessageMapper) {
        this(inboundMessageMapper, inboundMessageMapper instanceof OutboundMessageMapper ? (OutboundMessageMapper)((Object)inboundMessageMapper) : null);
    }

    public SimpleMessageConverter(OutboundMessageMapper<?> outboundMessageMapper) {
        this(outboundMessageMapper instanceof InboundMessageMapper ? (InboundMessageMapper)((Object)outboundMessageMapper) : null, outboundMessageMapper);
    }

    public SimpleMessageConverter(InboundMessageMapper<?> inboundMessageMapper, OutboundMessageMapper<?> outboundMessageMapper) {
        this.setInboundMessageMapper(inboundMessageMapper);
        this.setOutboundMessageMapper(outboundMessageMapper);
    }

    public void setInboundMessageMapper(InboundMessageMapper<?> inboundMessageMapper) {
        this.inboundMessageMapper = inboundMessageMapper != null ? inboundMessageMapper : new DefaultInboundMessageMapper();
    }

    public void setOutboundMessageMapper(OutboundMessageMapper<?> outboundMessageMapper) {
        this.outboundMessageMapper = outboundMessageMapper != null ? outboundMessageMapper : new DefaultOutboundMessageMapper();
    }

    @Override
    public <P> Message<P> toMessage(Object object) {
        try {
            return this.inboundMessageMapper.toMessage(object);
        }
        catch (Exception e) {
            throw new MessageConversionException("failed to convert object to Message", (Throwable)e);
        }
    }

    @Override
    public <P> Object fromMessage(Message<P> message) {
        try {
            return this.outboundMessageMapper.fromMessage(message);
        }
        catch (Exception e) {
            throw new MessageConversionException(message, "failed to convert Message to object", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultOutboundMessageMapper
    implements OutboundMessageMapper<Object> {
        private DefaultOutboundMessageMapper() {
        }

        @Override
        public Object fromMessage(Message<?> message) throws Exception {
            return message != null ? message.getPayload() : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultInboundMessageMapper
    implements InboundMessageMapper<Object> {
        private DefaultInboundMessageMapper() {
        }

        @Override
        public Message<?> toMessage(Object object) throws Exception {
            if (object == null) {
                return null;
            }
            if (object instanceof Message) {
                return (Message)object;
            }
            return MessageBuilder.withPayload(object).build();
        }
    }
}

