/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.transaction.IntegrationResourceHolder;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;
import org.springframework.integration.transaction.TransactionSynchronizationProcessor;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.ResourceHolderSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class DefaultTransactionSynchronizationFactory
implements TransactionSynchronizationFactory {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final TransactionSynchronizationProcessor processor;

    public DefaultTransactionSynchronizationFactory(TransactionSynchronizationProcessor processor) {
        Assert.notNull((Object)processor, (String)"'processor' must not be null");
        this.processor = processor;
    }

    public TransactionSynchronization create(Object key) {
        Assert.notNull((Object)key, (String)"'key' must not be null");
        Object resourceHolder = TransactionSynchronizationManager.getResource((Object)key);
        Assert.isInstanceOf(IntegrationResourceHolder.class, (Object)resourceHolder);
        return new DefaultTransactionalResourceSynchronization((IntegrationResourceHolder)resourceHolder, key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultTransactionalResourceSynchronization
    extends ResourceHolderSynchronization<IntegrationResourceHolder, Object> {
        private final IntegrationResourceHolder resourceHolder;

        public DefaultTransactionalResourceSynchronization(IntegrationResourceHolder resourceHolder, Object resourceKey) {
            super((ResourceHolder)resourceHolder, resourceKey);
            this.resourceHolder = resourceHolder;
        }

        public void beforeCommit(boolean readOnly) {
            if (DefaultTransactionSynchronizationFactory.this.logger.isTraceEnabled()) {
                DefaultTransactionSynchronizationFactory.this.logger.trace((Object)"'pre-Committing' transactional resource");
            }
            DefaultTransactionSynchronizationFactory.this.processor.processBeforeCommit(this.resourceHolder);
        }

        protected boolean shouldReleaseBeforeCompletion() {
            return false;
        }

        protected void processResourceAfterCommit(IntegrationResourceHolder resourceHolder) {
            if (DefaultTransactionSynchronizationFactory.this.logger.isTraceEnabled()) {
                DefaultTransactionSynchronizationFactory.this.logger.trace((Object)"'Committing' transactional resource");
            }
            DefaultTransactionSynchronizationFactory.this.processor.processAfterCommit(resourceHolder);
        }

        public void afterCompletion(int status) {
            if (status != 0) {
                if (DefaultTransactionSynchronizationFactory.this.logger.isTraceEnabled()) {
                    DefaultTransactionSynchronizationFactory.this.logger.trace((Object)"'Rolling back' transactional resource");
                }
                DefaultTransactionSynchronizationFactory.this.processor.processAfterRollback(this.resourceHolder);
            }
            super.afterCompletion(status);
        }
    }
}

