/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentEnricher
extends AbstractReplyProducingMessageHandler
implements Lifecycle {
    private final Map<Expression, Expression> propertyExpressions = new HashMap<Expression, Expression>();
    private final SpelExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private final StandardEvaluationContext sourceEvaluationContext = new StandardEvaluationContext();
    private final StandardEvaluationContext targetEvaluationContext = new StandardEvaluationContext();
    private volatile boolean shouldClonePayload = false;
    private Expression requestPayloadExpression;
    private volatile MessageChannel requestChannel;
    private volatile MessageChannel replyChannel;
    private volatile Gateway gateway = null;
    private volatile Long requestTimeout;
    private volatile Long replyTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyExpressions(Map<String, Expression> propertyExpressions) {
        Assert.notEmpty(propertyExpressions, (String)"propertyExpressions must not be empty");
        Map<Expression, Expression> map = this.propertyExpressions;
        synchronized (map) {
            this.propertyExpressions.clear();
            for (Map.Entry<String, Expression> entry : propertyExpressions.entrySet()) {
                String key = entry.getKey();
                Expression value = entry.getValue();
                Assert.notNull((Object)key, (String)"propertyExpressions key must not be null");
                Assert.notNull((Object)value, (String)"propertyExpressions value must not be null");
                this.propertyExpressions.put(this.parser.parseExpression(key), value);
            }
        }
    }

    public void setRequestChannel(MessageChannel requestChannel) {
        this.requestChannel = requestChannel;
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.replyChannel = replyChannel;
    }

    public void setRequestTimeout(Long requestTimeout) {
        Assert.notNull((Object)requestTimeout, (String)"requestTimeout must not be null");
        this.requestTimeout = requestTimeout;
    }

    public void setReplyTimeout(Long replyTimeout) {
        Assert.notNull((Object)replyTimeout, (String)"replyTimeout must not be null");
        this.replyTimeout = replyTimeout;
    }

    public void setRequestPayloadExpression(Expression requestPayloadExpression) {
        this.requestPayloadExpression = requestPayloadExpression;
    }

    public void setShouldClonePayload(boolean shouldClonePayload) {
        this.shouldClonePayload = shouldClonePayload;
    }

    @Override
    public void onInit() {
        super.onInit();
        if (this.replyChannel != null) {
            Assert.notNull((Object)this.requestChannel, (String)"If the replyChannel is set, then the requestChannel must not be null");
        }
        if (this.requestChannel != null) {
            this.gateway = new Gateway();
            this.gateway.setRequestChannel(this.requestChannel);
            if (this.requestTimeout != null) {
                this.gateway.setRequestTimeout(this.requestTimeout);
            }
            if (this.replyTimeout != null) {
                this.gateway.setReplyTimeout(this.replyTimeout);
            }
            if (this.replyChannel != null) {
                this.gateway.setReplyChannel(this.replyChannel);
            }
            this.gateway.afterPropertiesSet();
        }
        this.sourceEvaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        this.targetEvaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        BeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory != null) {
            this.sourceEvaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        }
    }

    @Override
    protected Object handleRequestMessage(Message<?> requestMessage) {
        Message<?> replyMessage;
        Message<Object> actualRequestMessage;
        Object targetPayload;
        Object requestPayload = requestMessage.getPayload();
        if (requestPayload instanceof Cloneable && this.shouldClonePayload) {
            try {
                Method cloneMethod = requestPayload.getClass().getMethod("clone", new Class[0]);
                targetPayload = ReflectionUtils.invokeMethod((Method)cloneMethod, requestPayload);
            }
            catch (Exception e) {
                throw new MessageHandlingException(requestMessage, "Failed to clone payload object", e);
            }
        } else {
            targetPayload = requestPayload;
        }
        if (this.requestPayloadExpression == null) {
            actualRequestMessage = requestMessage;
        } else {
            Object requestMessagePayload = this.requestPayloadExpression.getValue((EvaluationContext)this.sourceEvaluationContext, requestMessage);
            actualRequestMessage = MessageBuilder.withPayload(requestMessagePayload).copyHeaders(requestMessage.getHeaders()).build();
        }
        if (this.gateway == null) {
            replyMessage = actualRequestMessage;
        } else {
            replyMessage = this.gateway.sendAndReceiveMessage(actualRequestMessage);
            if (replyMessage == null) {
                return replyMessage;
            }
        }
        for (Map.Entry<Expression, Expression> entry : this.propertyExpressions.entrySet()) {
            Expression propertyExpression = entry.getKey();
            Expression valueExpression = entry.getValue();
            Object value = valueExpression.getValue((EvaluationContext)this.sourceEvaluationContext, replyMessage);
            propertyExpression.setValue((EvaluationContext)this.targetEvaluationContext, targetPayload, value);
        }
        return targetPayload;
    }

    public void start() {
        if (this.gateway != null) {
            this.gateway.start();
        }
    }

    public void stop() {
        if (this.gateway != null) {
            this.gateway.stop();
        }
    }

    public boolean isRunning() {
        if (this.gateway != null) {
            return this.gateway.isRunning();
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Gateway
    extends MessagingGatewaySupport {
        private Gateway() {
        }

        @Override
        protected Message<?> sendAndReceiveMessage(Object object) {
            return super.sendAndReceiveMessage(object);
        }
    }
}

