/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.integration.transformer.AbstractPayloadTransformer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapToObjectTransformer
extends AbstractPayloadTransformer<Map<?, ?>, Object> {
    private final Class<?> targetClass;
    private final String targetBeanName;

    public MapToObjectTransformer(Class<?> targetClass) {
        Assert.notNull(targetClass, (String)"targetClass must not be null");
        this.targetClass = targetClass;
        this.targetBeanName = null;
    }

    public MapToObjectTransformer(String beanName) {
        Assert.hasText((String)beanName, (String)"beanName must not be empty");
        this.targetBeanName = beanName;
        this.targetClass = null;
    }

    @Override
    protected Object transformPayload(Map<?, ?> payload) throws Exception {
        Object target = this.targetClass != null ? BeanUtils.instantiate(this.targetClass) : this.getBeanFactory().getBean(this.targetBeanName);
        DataBinder binder = new DataBinder(target);
        GenericConversionService conversionService = null;
        if (this.getBeanFactory() instanceof ConfigurableBeanFactory) {
            conversionService = ((ConfigurableBeanFactory)this.getBeanFactory()).getConversionService();
        }
        if (conversionService == null) {
            conversionService = ConversionServiceFactory.createDefaultConversionService();
        }
        binder.setConversionService((ConversionService)conversionService);
        binder.bind((PropertyValues)new MutablePropertyValues(payload));
        return target;
    }

    @Override
    protected void onInit() {
        if (StringUtils.hasText((String)this.targetBeanName)) {
            Assert.isTrue((boolean)this.getBeanFactory().isPrototype(this.targetBeanName), (String)("target bean [" + this.targetBeanName + "] must have 'prototype' scope"));
        }
    }
}

