/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.channel.interceptor.ChannelInterceptorAdapter;
import org.springframework.integration.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageTransformingChannelInterceptor
extends ChannelInterceptorAdapter {
    private final Transformer transformer;
    private volatile boolean transformOnSend = true;

    public MessageTransformingChannelInterceptor(Transformer transformer) {
        this.transformer = transformer;
    }

    public boolean getTransformOnSend() {
        return this.transformOnSend;
    }

    public void setTransformOnSend(boolean transformOnSend) {
        this.transformOnSend = transformOnSend;
    }

    @Override
    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        if (this.transformOnSend) {
            message = this.transformer.transform(message);
        }
        return message;
    }

    @Override
    public Message<?> postReceive(Message<?> message, MessageChannel channel) {
        if (!this.transformOnSend) {
            message = this.transformer.transform(message);
        }
        return message;
    }
}

