/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import org.springframework.integration.MessagingException;
import org.springframework.integration.util.LockRegistry;

public abstract class WhileLockedProcessor {
    private final Object key;
    private final LockRegistry lockRegistry;

    public WhileLockedProcessor(LockRegistry lockRegistry, Object key) {
        this.key = key;
        this.lockRegistry = lockRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doWhileLocked() throws IOException {
        Lock lock = this.lockRegistry.obtain(this.key);
        try {
            lock.lockInterruptibly();
            try {
                this.whileLocked();
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MessagingException("Thread was interrupted while performing task", (Throwable)e);
        }
    }

    protected abstract void whileLocked() throws IOException;
}

