/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.springframework.integration.Message;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.aggregator.SequenceNumberComparator;
import org.springframework.integration.store.MessageGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResequencingMessageGroupProcessor
implements MessageGroupProcessor {
    private final Comparator<Message<?>> comparator = new SequenceNumberComparator();

    @Override
    public Object processMessageGroup(MessageGroup group) {
        Collection<Message<?>> messages = group.getMessages();
        if (messages.size() > 0) {
            int previousSequence;
            ArrayList sorted = new ArrayList(messages);
            Collections.sort(sorted, this.comparator);
            ArrayList<Message> partialSequence = new ArrayList<Message>();
            int currentSequence = previousSequence = this.extractSequenceNumber((Message)sorted.get(0)).intValue();
            for (Message message : sorted) {
                previousSequence = currentSequence;
                currentSequence = this.extractSequenceNumber(message);
                if (currentSequence - 1 > previousSequence) break;
                partialSequence.add(message);
            }
            return partialSequence;
        }
        return null;
    }

    private Integer extractSequenceNumber(Message<?> message) {
        return message.getHeaders().getSequenceNumber();
    }
}

