/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.OrderComparator;
import org.springframework.core.convert.ConversionService;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.channel.ChannelInterceptor;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.history.TrackableComponent;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageChannel
extends IntegrationObjectSupport
implements MessageChannel,
TrackableComponent {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile boolean shouldTrack = false;
    private volatile Class<?>[] datatypes = new Class[]{Object.class};
    private final ChannelInterceptorList interceptors = new ChannelInterceptorList();

    @Override
    public String getComponentType() {
        return "channel";
    }

    @Override
    public void setShouldTrack(boolean shouldTrack) {
        this.shouldTrack = shouldTrack;
    }

    public void setDatatypes(Class<?> ... datatypes) {
        Class[] classArray;
        if (datatypes != null && datatypes.length > 0) {
            classArray = datatypes;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Object.class;
        }
        this.datatypes = classArray;
    }

    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        Collections.sort(interceptors, new OrderComparator());
        this.interceptors.set(interceptors);
    }

    public void addInterceptor(ChannelInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    public void setConversionService(ConversionService conversionService) {
        super.setConversionService(conversionService);
    }

    protected ChannelInterceptorList getInterceptors() {
        return this.interceptors;
    }

    @Override
    public final boolean send(Message<?> message) {
        return this.send(message, -1L);
    }

    @Override
    public final boolean send(Message<?> message, long timeout) {
        Assert.notNull(message, (String)"message must not be null");
        Assert.notNull(message.getPayload(), (String)"message payload must not be null");
        if (this.shouldTrack) {
            message = MessageHistory.write(message, this);
        }
        message = this.convertPayloadIfNecessary(message);
        if ((message = this.interceptors.preSend(message, this)) == null) {
            return false;
        }
        try {
            boolean sent = this.doSend(message, timeout);
            this.interceptors.postSend(message, this, sent);
            return sent;
        }
        catch (Exception e) {
            if (e instanceof MessagingException) {
                throw (MessagingException)e;
            }
            throw new MessageDeliveryException(message, "failed to send Message to channel '" + this.getComponentName() + "'", e);
        }
    }

    private Message<?> convertPayloadIfNecessary(Message<?> message) {
        for (Class<?> datatype : this.datatypes) {
            if (!datatype.isAssignableFrom(message.getPayload().getClass())) continue;
            return message;
        }
        ConversionService conversionService = this.getConversionService();
        if (conversionService != null) {
            for (Class<?> datatype : this.datatypes) {
                if (!conversionService.canConvert(message.getPayload().getClass(), datatype)) continue;
                Object convertedPayload = conversionService.convert(message.getPayload(), datatype);
                return MessageBuilder.withPayload(convertedPayload).copyHeaders(message.getHeaders()).build();
            }
        }
        throw new MessageDeliveryException(message, "Channel '" + this.getComponentName() + "' expected one of the following datataypes [" + StringUtils.arrayToCommaDelimitedString((Object[])this.datatypes) + "], but received [" + message.getPayload().getClass() + "]");
    }

    protected abstract boolean doSend(Message<?> var1, long var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChannelInterceptorList {
        private final List<ChannelInterceptor> interceptors = new CopyOnWriteArrayList<ChannelInterceptor>();

        protected ChannelInterceptorList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean set(List<ChannelInterceptor> interceptors) {
            List<ChannelInterceptor> list = this.interceptors;
            synchronized (list) {
                this.interceptors.clear();
                return this.interceptors.addAll(interceptors);
            }
        }

        public boolean add(ChannelInterceptor interceptor) {
            return this.interceptors.add(interceptor);
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            if (AbstractMessageChannel.this.logger.isDebugEnabled()) {
                AbstractMessageChannel.this.logger.debug((Object)("preSend on channel '" + channel + "', message: " + message));
            }
            for (ChannelInterceptor interceptor : this.interceptors) {
                message = interceptor.preSend(message, channel);
                if (message != null) continue;
                return null;
            }
            return message;
        }

        public void postSend(Message<?> message, MessageChannel channel, boolean sent) {
            if (AbstractMessageChannel.this.logger.isDebugEnabled()) {
                AbstractMessageChannel.this.logger.debug((Object)("postSend (sent=" + sent + ") on channel '" + channel + "', message: " + message));
            }
            for (ChannelInterceptor interceptor : this.interceptors) {
                interceptor.postSend(message, channel, sent);
            }
        }

        public boolean preReceive(MessageChannel channel) {
            if (AbstractMessageChannel.this.logger.isTraceEnabled()) {
                AbstractMessageChannel.this.logger.trace((Object)("preReceive on channel '" + channel + "'"));
            }
            for (ChannelInterceptor interceptor : this.interceptors) {
                if (interceptor.preReceive(channel)) continue;
                return false;
            }
            return true;
        }

        public Message<?> postReceive(Message<?> message, MessageChannel channel) {
            if (message != null && AbstractMessageChannel.this.logger.isDebugEnabled()) {
                AbstractMessageChannel.this.logger.debug((Object)("postReceive on channel '" + channel + "', message: " + message));
            } else if (AbstractMessageChannel.this.logger.isTraceEnabled()) {
                AbstractMessageChannel.this.logger.trace((Object)("postReceive on channel '" + channel + "', message is null"));
            }
            for (ChannelInterceptor interceptor : this.interceptors) {
                message = interceptor.postReceive(message, channel);
                if (message != null) continue;
                return null;
            }
            return message;
        }
    }
}

