/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel.interceptor;

import java.util.Arrays;
import java.util.List;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.channel.interceptor.ChannelInterceptorAdapter;
import org.springframework.integration.core.MessageSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageSelectingInterceptor
extends ChannelInterceptorAdapter {
    private final List<MessageSelector> selectors;

    public MessageSelectingInterceptor(MessageSelector ... selectors) {
        this.selectors = Arrays.asList(selectors);
    }

    @Override
    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        for (MessageSelector selector : this.selectors) {
            if (selector.accept(message)) continue;
            throw new MessageDeliveryException(message, "selector '" + selector + "' did not accept message");
        }
        return message;
    }
}

