/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.config.AbstractSimpleMessageHandlerFactoryBean;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractStandardMessageHandlerFactoryBean
extends AbstractSimpleMessageHandlerFactoryBean<MessageHandler> {
    private static final ExpressionParser expressionParser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private volatile Object targetObject;
    private volatile String targetMethodName;
    private volatile Expression expression;

    AbstractStandardMessageHandlerFactoryBean() {
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
    }

    public void setTargetMethodName(String targetMethodName) {
        this.targetMethodName = targetMethodName;
    }

    public void setExpressionString(String expressionString) {
        this.expression = expressionParser.parseExpression(expressionString);
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    protected MessageHandler createHandler() {
        MessageHandler handler;
        if (this.targetObject == null) {
            Assert.isTrue((!StringUtils.hasText((String)this.targetMethodName) ? 1 : 0) != 0, (String)"The target method is only allowed when a target object (ref or inner bean) is also provided.");
        }
        if (this.targetObject != null) {
            Assert.state((this.expression == null ? 1 : 0) != 0, (String)"The 'targetObject' and 'expression' properties are mutually exclusive.");
            handler = this.targetObject instanceof MessageProcessor ? this.createMessageProcessingHandler((MessageProcessor)this.targetObject) : this.createMethodInvokingHandler(this.targetObject, this.targetMethodName);
        } else {
            handler = this.expression != null ? this.createExpressionEvaluatingHandler(this.expression) : this.createDefaultHandler();
        }
        return handler;
    }

    abstract MessageHandler createMethodInvokingHandler(Object var1, String var2);

    MessageHandler createExpressionEvaluatingHandler(Expression expression) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support expressions.");
    }

    <T> MessageHandler createMessageProcessingHandler(MessageProcessor<T> processor) {
        return this.createMethodInvokingHandler(processor, "processMessage");
    }

    MessageHandler createDefaultHandler() {
        throw new IllegalArgumentException("Exactly one of the 'targetObject' or 'expression' property is required.");
    }

    <T> T extractTypeIfPossible(Object targetObject, Class<T> expectedType) {
        if (targetObject == null) {
            return null;
        }
        if (expectedType.isAssignableFrom(targetObject.getClass())) {
            return (T)targetObject;
        }
        if (targetObject instanceof Advised) {
            TargetSource targetSource = ((Advised)targetObject).getTargetSource();
            if (targetSource == null) {
                return null;
            }
            try {
                return this.extractTypeIfPossible(targetSource.getTarget(), expectedType);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }
}

