/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AnnotationFinder {
    AnnotationFinder() {
    }

    public static Method findAnnotatedMethod(Object target, final Class<? extends Annotation> annotationType) {
        final AtomicReference reference = new AtomicReference();
        ReflectionUtils.doWithMethods(AnnotationFinder.getTargetClass(target), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                if (AnnotationUtils.findAnnotation((Method)method, (Class)annotationType) != null) {
                    reference.set(method);
                }
            }
        });
        return (Method)reference.get();
    }

    private static Class<?> getTargetClass(Object targetObject) {
        Class<?> superClass;
        Class<?> targetClass = targetObject.getClass();
        if (AopUtils.isAopProxy((Object)targetObject)) {
            targetClass = AopUtils.getTargetClass((Object)targetObject);
        } else if (AopUtils.isCglibProxyClass(targetClass) && !Object.class.equals(superClass = targetObject.getClass().getSuperclass())) {
            targetClass = superClass;
        }
        return targetClass;
    }
}

