/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.Lifecycle;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.MethodFilter;
import org.springframework.integration.config.AbstractSimpleMessageHandlerFactoryBean;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.handler.ExpressionCommandMessageProcessor;
import org.springframework.integration.handler.ServiceActivatingHandler;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.util.CustomizableThreadCreator;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionControlBusFactoryBean
extends AbstractSimpleMessageHandlerFactoryBean<MessageHandler> {
    private volatile Long sendTimeout;
    private final MethodFilter methodFilter = new ControlBusMethodFilter();

    public void setSendTimeout(Long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    @Override
    protected MessageHandler createHandler() {
        ExpressionCommandMessageProcessor processor = new ExpressionCommandMessageProcessor(this.methodFilter);
        processor.setBeanFactory(this.getBeanFactory());
        ServiceActivatingHandler handler = new ServiceActivatingHandler(processor);
        if (this.sendTimeout != null) {
            handler.setSendTimeout(this.sendTimeout);
        }
        return handler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ControlBusMethodFilter
    implements MethodFilter {
        private ControlBusMethodFilter() {
        }

        public List<Method> filter(List<Method> methods) {
            ArrayList<Method> supportedMethods = new ArrayList<Method>();
            for (Method method : methods) {
                if (!this.accept(method)) continue;
                supportedMethods.add(method);
            }
            return supportedMethods;
        }

        private boolean accept(Method method) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (Lifecycle.class.isAssignableFrom(declaringClass) && ReflectionUtils.findMethod(Lifecycle.class, (String)method.getName(), (Class[])method.getParameterTypes()) != null) {
                return true;
            }
            if (CustomizableThreadCreator.class.isAssignableFrom(declaringClass) && (method.getName().startsWith("get") || method.getName().startsWith("set") || method.getName().startsWith("shutdown"))) {
                return true;
            }
            return this.hasAnnotation(method, ManagedAttribute.class) || this.hasAnnotation(method, ManagedOperation.class);
        }

        private boolean hasAnnotation(Method method, Class<? extends Annotation> annotationType) {
            return AnnotationUtils.findAnnotation((Method)method, annotationType) != null;
        }
    }
}

