/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.expression.Expression;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.config.AbstractStandardMessageHandlerFactoryBean;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.filter.ExpressionEvaluatingSelector;
import org.springframework.integration.filter.MessageFilter;
import org.springframework.integration.filter.MethodInvokingSelector;
import org.springframework.util.StringUtils;

public class FilterFactoryBean
extends AbstractStandardMessageHandlerFactoryBean {
    private volatile MessageChannel discardChannel;
    private volatile Boolean throwExceptionOnRejection;
    private volatile Long sendTimeout;

    public void setDiscardChannel(MessageChannel discardChannel) {
        this.discardChannel = discardChannel;
    }

    public void setThrowExceptionOnRejection(Boolean throwExceptionOnRejection) {
        this.throwExceptionOnRejection = throwExceptionOnRejection;
    }

    public void setSendTimeout(Long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    MessageHandler createMethodInvokingHandler(Object targetObject, String targetMethodName) {
        MessageSelector selector = null;
        selector = targetObject instanceof MessageSelector ? (MessageSelector)targetObject : (StringUtils.hasText((String)targetMethodName) ? new MethodInvokingSelector(targetObject, targetMethodName) : new MethodInvokingSelector(targetObject));
        return this.createFilter(selector);
    }

    MessageHandler createExpressionEvaluatingHandler(Expression expression) {
        return this.createFilter(new ExpressionEvaluatingSelector(expression));
    }

    private MessageFilter createFilter(MessageSelector selector) {
        MessageFilter filter = new MessageFilter(selector);
        if (this.throwExceptionOnRejection != null) {
            filter.setThrowExceptionOnRejection(this.throwExceptionOnRejection);
        }
        if (this.discardChannel != null) {
            filter.setDiscardChannel(this.discardChannel);
        }
        if (this.sendTimeout != null) {
            filter.setSendTimeout(this.sendTimeout);
        }
        return filter;
    }
}

