/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.integration.MessageHeaders;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdGeneratorConfigurer
implements ApplicationListener<ApplicationContextEvent> {
    private static volatile String generatorContextId;
    private final Log logger = LogFactory.getLog(this.getClass());

    public void onApplicationEvent(ApplicationContextEvent event) {
        ApplicationContext context = event.getApplicationContext();
        if (event instanceof ContextRefreshedEvent) {
            boolean contextHasIdGenerator;
            boolean bl = contextHasIdGenerator = context.getBeanNamesForType(MessageHeaders.IdGenerator.class).length > 0;
            if (contextHasIdGenerator && this.setIdGenerator(context)) {
                generatorContextId = context.getId();
            }
        } else if (event instanceof ContextClosedEvent && context.getId().equals(generatorContextId)) {
            this.unsetIdGenerator();
            generatorContextId = null;
        }
    }

    private boolean setIdGenerator(ApplicationContext context) {
        try {
            MessageHeaders.IdGenerator idGeneratorBean = (MessageHeaders.IdGenerator)context.getBean(MessageHeaders.IdGenerator.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("using custom MessageHeaders.IdGenerator [" + idGeneratorBean.getClass() + "]"));
            }
            Field idGeneratorField = ReflectionUtils.findField(MessageHeaders.class, (String)"idGenerator");
            ReflectionUtils.makeAccessible((Field)idGeneratorField);
            MessageHeaders.IdGenerator currentIdGenerator = (MessageHeaders.IdGenerator)ReflectionUtils.getField((Field)idGeneratorField, null);
            if (currentIdGenerator != null) {
                if (currentIdGenerator.equals(idGeneratorBean)) {
                    return false;
                }
                throw new BeanDefinitionStoreException("'MessageHeaders.idGenerator' has already been set and can not be set again");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Message IDs will be generated using custom IdGenerator [" + idGeneratorBean.getClass() + "]"));
            }
            ReflectionUtils.setField((Field)idGeneratorField, null, (Object)idGeneratorBean);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Unable to locate MessageHeaders.IdGenerator. Will use default: UUID.randomUUID()");
            }
            return false;
        }
        catch (IllegalStateException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Unexpected exception occurred while accessing idGenerator of MessageHeaders. Will use default: UUID.randomUUID()", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private void unsetIdGenerator() {
        block2: {
            try {
                Field idGeneratorField = ReflectionUtils.findField(MessageHeaders.class, (String)"idGenerator");
                ReflectionUtils.makeAccessible((Field)idGeneratorField);
                idGeneratorField.set(null, null);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn((Object)"Unexpected exception occurred while accessing idGenerator of MessageHeaders.", (Throwable)e);
            }
        }
    }
}

