/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.expression.Expression;
import org.springframework.integration.config.AbstractStandardMessageHandlerFactoryBean;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.integration.splitter.DefaultMessageSplitter;
import org.springframework.integration.splitter.ExpressionEvaluatingSplitter;
import org.springframework.integration.splitter.MethodInvokingSplitter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SplitterFactoryBean
extends AbstractStandardMessageHandlerFactoryBean {
    private volatile Long sendTimeout;
    private volatile boolean requiresReply;
    private volatile boolean applySequence = true;
    private volatile String delimiters;

    public void setSendTimeout(Long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public boolean isRequiresReply() {
        return this.requiresReply;
    }

    public void setRequiresReply(boolean requiresReply) {
        this.requiresReply = requiresReply;
    }

    public void setApplySequence(boolean applySequence) {
        this.applySequence = applySequence;
    }

    public void setDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }

    MessageHandler createMethodInvokingHandler(Object targetObject, String targetMethodName) {
        Assert.notNull((Object)targetObject, (String)"targetObject must not be null");
        AbstractMessageSplitter splitter = this.extractTypeIfPossible(targetObject, AbstractMessageSplitter.class);
        if (splitter == null) {
            splitter = this.createMethodInvokingSplitter(targetObject, targetMethodName);
            this.configureSplitter(splitter);
        } else {
            Assert.isTrue((!StringUtils.hasText((String)targetMethodName) ? 1 : 0) != 0, (String)"target method should not be provided when the target object is an implementation of AbstractMessageSplitter");
            this.configureSplitter(splitter);
            if (targetObject instanceof MessageHandler) {
                return (MessageHandler)targetObject;
            }
        }
        return splitter;
    }

    private AbstractMessageSplitter createMethodInvokingSplitter(Object targetObject, String targetMethodName) {
        return StringUtils.hasText((String)targetMethodName) ? new MethodInvokingSplitter(targetObject, targetMethodName) : new MethodInvokingSplitter(targetObject);
    }

    MessageHandler createExpressionEvaluatingHandler(Expression expression) {
        return this.configureSplitter(new ExpressionEvaluatingSplitter(expression));
    }

    MessageHandler createDefaultHandler() {
        return this.configureSplitter(new DefaultMessageSplitter());
    }

    private AbstractMessageSplitter configureSplitter(AbstractMessageSplitter splitter) {
        if (this.sendTimeout != null) {
            splitter.setSendTimeout(this.sendTimeout);
        }
        if (this.delimiters != null) {
            Assert.isTrue((boolean)(splitter instanceof DefaultMessageSplitter), (String)"The 'delimiters' property is only available for a Splitter definition where no 'ref', 'expression', or inner bean has been provided.");
            ((DefaultMessageSplitter)splitter).setDelimiters(this.delimiters);
        }
        splitter.setRequiresReply(this.requiresReply);
        splitter.setApplySequence(this.applySequence);
        return splitter;
    }
}

