/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.expression.Expression;
import org.springframework.integration.config.AbstractStandardMessageHandlerFactoryBean;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.transformer.ExpressionEvaluatingTransformer;
import org.springframework.integration.transformer.MessageTransformingHandler;
import org.springframework.integration.transformer.MethodInvokingTransformer;
import org.springframework.integration.transformer.Transformer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TransformerFactoryBean
extends AbstractStandardMessageHandlerFactoryBean {
    private volatile Long sendTimeout;

    public void setSendTimeout(Long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    MessageHandler createMethodInvokingHandler(Object targetObject, String targetMethodName) {
        Assert.notNull((Object)targetObject, (String)"targetObject must not be null");
        Transformer transformer = null;
        transformer = targetObject instanceof Transformer ? (Transformer)targetObject : (StringUtils.hasText((String)targetMethodName) ? new MethodInvokingTransformer(targetObject, targetMethodName) : new MethodInvokingTransformer(targetObject));
        return this.createHandler(transformer);
    }

    MessageHandler createExpressionEvaluatingHandler(Expression expression) {
        ExpressionEvaluatingTransformer transformer = new ExpressionEvaluatingTransformer(expression);
        return this.createHandler(transformer);
    }

    private MessageTransformingHandler createHandler(Transformer transformer) {
        MessageTransformingHandler handler = new MessageTransformingHandler(transformer);
        if (this.sendTimeout != null) {
            handler.setSendTimeout(this.sendTimeout);
        }
        return handler;
    }
}

