/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.aggregator.AggregatingMessageHandler;
import org.springframework.integration.aggregator.MethodInvokingCorrelationStrategy;
import org.springframework.integration.aggregator.MethodInvokingMessageGroupProcessor;
import org.springframework.integration.aggregator.MethodInvokingReleaseStrategy;
import org.springframework.integration.annotation.Aggregator;
import org.springframework.integration.annotation.CorrelationStrategy;
import org.springframework.integration.annotation.ReleaseStrategy;
import org.springframework.integration.config.annotation.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.store.SimpleMessageStore;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatorAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<Aggregator> {
    public AggregatorAnnotationPostProcessor(ListableBeanFactory beanFactory) {
        super(beanFactory);
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, Aggregator annotation) {
        String outputChannelName;
        MethodInvokingMessageGroupProcessor processor = new MethodInvokingMessageGroupProcessor(bean, method);
        MethodInvokingReleaseStrategy releaseStrategy = this.getReleaseStrategy(bean);
        MethodInvokingCorrelationStrategy correlationStrategy = this.getCorrelationStrategy(bean);
        AggregatingMessageHandler handler = new AggregatingMessageHandler(processor, new SimpleMessageStore(), correlationStrategy, releaseStrategy);
        String discardChannelName = annotation.discardChannel();
        if (StringUtils.hasText((String)discardChannelName)) {
            MessageChannel discardChannel = this.channelResolver.resolveChannelName(discardChannelName);
            Assert.notNull((Object)discardChannel, (String)("failed to resolve discardChannel '" + discardChannelName + "'"));
            handler.setDiscardChannel(discardChannel);
        }
        if (StringUtils.hasText((String)(outputChannelName = annotation.outputChannel()))) {
            handler.setOutputChannel(this.channelResolver.resolveChannelName(outputChannelName));
        }
        handler.setSendTimeout(annotation.sendTimeout());
        handler.setSendPartialResultOnExpiry(annotation.sendPartialResultsOnExpiry());
        handler.setBeanFactory(this.beanFactory);
        handler.afterPropertiesSet();
        return handler;
    }

    private MethodInvokingReleaseStrategy getReleaseStrategy(final Object bean) {
        final AtomicReference reference = new AtomicReference();
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Annotation annotation = AnnotationUtils.getAnnotation((Method)method, ReleaseStrategy.class);
                if (annotation != null) {
                    reference.set(new MethodInvokingReleaseStrategy(bean, method));
                }
            }
        });
        return (MethodInvokingReleaseStrategy)reference.get();
    }

    private MethodInvokingCorrelationStrategy getCorrelationStrategy(final Object bean) {
        final AtomicReference reference = new AtomicReference();
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Annotation annotation = AnnotationUtils.getAnnotation((Method)method, CorrelationStrategy.class);
                if (annotation != null) {
                    reference.set(new MethodInvokingCorrelationStrategy(bean, method));
                }
            }
        });
        return (MethodInvokingCorrelationStrategy)reference.get();
    }
}

