/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.reflect.Method;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.integration.annotation.Transformer;
import org.springframework.integration.config.annotation.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.transformer.MessageTransformingHandler;
import org.springframework.integration.transformer.MethodInvokingTransformer;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<Transformer> {
    public TransformerAnnotationPostProcessor(ListableBeanFactory beanFactory) {
        super(beanFactory);
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, Transformer annotation) {
        MethodInvokingTransformer transformer = new MethodInvokingTransformer(bean, method);
        MessageTransformingHandler handler = new MessageTransformingHandler(transformer);
        String outputChannelName = annotation.outputChannel();
        if (StringUtils.hasText((String)outputChannelName)) {
            handler.setOutputChannel(this.channelResolver.resolveChannelName(outputChannelName));
        }
        return handler;
    }
}

