/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractChannelAdapterParser
extends AbstractBeanDefinitionParser {
    protected final String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = element.getAttribute("id");
        if (!element.hasAttribute("channel")) {
            id = id + ".adapter";
        } else if (!StringUtils.hasText((String)id)) {
            id = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)parserContext.getRegistry(), (boolean)parserContext.isNested());
        }
        return id;
    }

    protected final AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String channelName = element.getAttribute("channel");
        if (!StringUtils.hasText((String)channelName)) {
            channelName = this.createDirectChannel(element, parserContext);
        }
        return this.doParse(element, parserContext, channelName);
    }

    private String createDirectChannel(Element element, ParserContext parserContext) {
        if (parserContext.isNested()) {
            return null;
        }
        String channelId = element.getAttribute("id");
        if (!StringUtils.hasText((String)channelId)) {
            parserContext.getReaderContext().error("The channel-adapter's 'id' attribute is required when no 'channel' reference has been provided, because that 'id' would be used for the created channel.", (Object)element);
        }
        BeanDefinitionBuilder channelBuilder = BeanDefinitionBuilder.genericBeanDefinition(DirectChannel.class);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)channelBuilder.getBeanDefinition(), channelId);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
        return channelId;
    }

    protected abstract AbstractBeanDefinition doParse(Element var1, ParserContext var2, String var3);
}

