/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.endpoint.ExpressionEvaluatingMessageSource;
import org.springframework.integration.endpoint.MethodInvokingMessageSource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class DefaultInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        Object result = null;
        BeanComponentDefinition innnerBeanDef = IntegrationNamespaceUtils.parseInnerHandlerDefinition(element, parserContext);
        String sourceRef = element.getAttribute("ref");
        String methodName = element.getAttribute("method");
        String expressionString = element.getAttribute("expression");
        boolean isInnerDef = innnerBeanDef != null;
        boolean isRef = StringUtils.hasText((String)sourceRef);
        boolean isExpression = StringUtils.hasText((String)expressionString);
        boolean hasMethod = StringUtils.hasText((String)methodName);
        if (!(isInnerDef ^ (isRef ^ isExpression))) {
            parserContext.getReaderContext().error("Exactly one of the 'ref', 'expression' or inner bean is required.", (Object)element);
        }
        if (isInnerDef) {
            result = hasMethod ? this.parseMethodInvokingSource((BeanMetadataElement)innnerBeanDef, methodName, element, parserContext) : innnerBeanDef;
        } else if (isExpression) {
            if (hasMethod) {
                parserContext.getReaderContext().error("The 'method' attribute can't be used with 'expression' attribute.", (Object)element);
            }
            String expressionBeanName = this.parseExpression(expressionString, element, parserContext);
            result = new RuntimeBeanReference(expressionBeanName);
        } else if (isRef) {
            RuntimeBeanReference sourceValue = new RuntimeBeanReference(sourceRef);
            result = hasMethod ? this.parseMethodInvokingSource((BeanMetadataElement)sourceValue, methodName, element, parserContext) : sourceValue;
        } else {
            parserContext.getReaderContext().error("One of the following is required: 'ref' attribute, 'expression' attribute, or an inner-bean definition.", (Object)element);
        }
        return result;
    }

    private BeanMetadataElement parseMethodInvokingSource(BeanMetadataElement targetObject, String methodName, Element element, ParserContext parserContext) {
        BeanDefinitionBuilder sourceBuilder = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingMessageSource.class);
        sourceBuilder.addPropertyValue("object", (Object)targetObject);
        sourceBuilder.addPropertyValue("methodName", (Object)methodName);
        this.parseHeaderExpressions(sourceBuilder, element, parserContext);
        String sourceRef = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)sourceBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        return new RuntimeBeanReference(sourceRef);
    }

    private String parseExpression(String expressionString, Element element, ParserContext parserContext) {
        BeanDefinitionBuilder sourceBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionEvaluatingMessageSource.class);
        RootBeanDefinition expressionDef = new RootBeanDefinition(ExpressionFactoryBean.class);
        expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)expressionString);
        sourceBuilder.addConstructorArgValue((Object)expressionDef);
        sourceBuilder.addConstructorArgValue(null);
        this.parseHeaderExpressions(sourceBuilder, element, parserContext);
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)sourceBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }

    private void parseHeaderExpressions(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
        List headerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"header");
        if (!CollectionUtils.isEmpty((Collection)headerElements)) {
            ManagedMap headerExpressions = new ManagedMap();
            for (Element headerElement : headerElements) {
                boolean hasExpression;
                String headerName = headerElement.getAttribute("name");
                String headerValue = headerElement.getAttribute("value");
                String headerExpression = headerElement.getAttribute("expression");
                boolean hasValue = StringUtils.hasText((String)headerValue);
                if (!(hasValue ^ (hasExpression = StringUtils.hasText((String)headerExpression)))) {
                    parserContext.getReaderContext().error("exactly one of 'value' or 'expression' is required on a header sub-element", parserContext.extractSource((Object)headerElement));
                    continue;
                }
                RootBeanDefinition expressionDef = null;
                if (hasValue) {
                    expressionDef = new RootBeanDefinition(LiteralExpression.class);
                    expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)headerValue);
                } else {
                    expressionDef = new RootBeanDefinition(ExpressionFactoryBean.class);
                    expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)headerExpression);
                }
                headerExpressions.put((Object)headerName, (Object)expressionDef);
            }
            builder.addPropertyValue("headerExpressions", (Object)headerExpressions);
        }
    }
}

