/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.handler.DelayHandler;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class DelayerParser
extends AbstractConsumerEndpointParser {
    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        boolean hasDelayHeaderName;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(DelayHandler.class);
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            parserContext.getReaderContext().error("The 'id' attribute is required.", (Object)element);
        }
        String defaultDelay = element.getAttribute("default-delay");
        String delayHeaderName = element.getAttribute("delay-header-name");
        boolean hasDefaultDelay = StringUtils.hasText((String)defaultDelay);
        if (!(hasDefaultDelay | (hasDelayHeaderName = StringUtils.hasText((String)delayHeaderName)))) {
            parserContext.getReaderContext().error("The 'default-delay' or 'delay-header-name' attributes should be provided.", (Object)element);
        }
        builder.addConstructorArgValue((Object)(id + ".messageGroupId"));
        String scheduler = element.getAttribute("scheduler");
        if (StringUtils.hasText((String)scheduler)) {
            builder.addConstructorArgReference(scheduler);
        }
        if (hasDefaultDelay) {
            builder.addPropertyValue("defaultDelay", (Object)defaultDelay);
        }
        if (hasDelayHeaderName) {
            builder.addPropertyValue("delayHeaderName", (Object)delayHeaderName);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, "message-store");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "send-timeout");
        Element txElement = DomUtils.getChildElementByTagName((Element)element, (String)"transactional");
        Element adviceChainElement = DomUtils.getChildElementByTagName((Element)element, (String)"advice-chain");
        IntegrationNamespaceUtils.configureAndSetAdviceChainIfPresent(adviceChainElement, txElement, (BeanDefinition)builder.getRawBeanDefinition(), parserContext, "delayedAdviceChain");
        return builder;
    }
}

