/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.transformer.ContentEnricher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class EnricherParser
extends AbstractConsumerEndpointParser {
    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ContentEnricher.class);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, "request-channel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, "reply-channel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "request-timeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "reply-timeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "requires-reply");
        List propertyElements = DomUtils.getChildElementsByTagName((Element)element, (String)"property");
        if (!CollectionUtils.isEmpty((Collection)propertyElements)) {
            ManagedMap propertyExpressions = new ManagedMap();
            for (Element propertyElement : propertyElements) {
                BeanDefinitionBuilder expressionBuilder;
                String name = propertyElement.getAttribute("name");
                String value = propertyElement.getAttribute("value");
                String expression = propertyElement.getAttribute("expression");
                if (StringUtils.hasText((String)value) && StringUtils.hasText((String)expression)) {
                    parserContext.getReaderContext().error("The 'value' and 'expression' attributes are mutually exclusive on an <enricher> element's <property> sub-element.", parserContext.extractSource((Object)propertyElement));
                }
                if (StringUtils.hasText((String)value)) {
                    expressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(LiteralExpression.class);
                    expressionBuilder.addConstructorArgValue((Object)value);
                    propertyExpressions.put((Object)name, (Object)expressionBuilder.getBeanDefinition());
                    continue;
                }
                if (StringUtils.hasText((String)expression)) {
                    expressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class);
                    expressionBuilder.addConstructorArgValue((Object)expression);
                    propertyExpressions.put((Object)name, (Object)expressionBuilder.getBeanDefinition());
                    continue;
                }
                parserContext.getReaderContext().error("Exactly one of 'value' or 'expression' attributes must be provided on an <enricher> element's <property> sub-element.", parserContext.extractSource((Object)propertyElement));
            }
            builder.addPropertyValue("propertyExpressions", (Object)propertyExpressions);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "should-clone-payload");
        String requestPayloadExpression = element.getAttribute("request-payload-expression");
        if (StringUtils.hasText((String)requestPayloadExpression)) {
            BeanDefinitionBuilder expressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class);
            expressionBuilder.addConstructorArgValue((Object)requestPayloadExpression);
            builder.addPropertyValue("requestPayloadExpression", (Object)expressionBuilder.getBeanDefinition());
        }
        return builder;
    }
}

