/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayParser
extends AbstractSimpleBeanDefinitionParser {
    private static String[] referenceAttributes = new String[]{"default-request-channel", "default-reply-channel", "error-channel", "message-mapper", "async-executor"};
    private static String[] innerAttributes = new String[]{"request-channel", "reply-channel", "request-timeout", "reply-timeout", "error-channel"};

    protected String getBeanClassName(Element element) {
        return "org.springframework.integration.gateway.GatewayProxyFactoryBean";
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return !ObjectUtils.containsElement((Object[])referenceAttributes, (Object)attributeName) && !ObjectUtils.containsElement((Object[])innerAttributes, (Object)attributeName) && super.isEligibleAttribute(attributeName);
    }

    protected void postProcess(BeanDefinitionBuilder builder, Element element) {
        if ("chain".equals(element.getParentNode().getLocalName())) {
            this.postProcessInnerGateway(builder, element);
        } else {
            this.postProcessGateway(builder, element);
        }
    }

    private void postProcessInnerGateway(BeanDefinitionBuilder builder, Element element) {
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, "request-channel", "defaultRequestChannel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, "reply-channel", "defaultReplyChannel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "request-timeout", "defaultRequestTimeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "reply-timeout", "defaultReplyTimeout");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, "error-channel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, "async-executor");
    }

    private void postProcessGateway(BeanDefinitionBuilder builder, Element element) {
        for (String attributeName : referenceAttributes) {
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, attributeName);
        }
        List elements = DomUtils.getChildElementsByTagName((Element)element, (String)"method");
        ManagedMap methodMetadataMap = null;
        if (elements != null && elements.size() > 0) {
            methodMetadataMap = new ManagedMap();
        }
        for (Element methodElement : elements) {
            String methodName = methodElement.getAttribute("name");
            BeanDefinitionBuilder methodMetadataBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.gateway.GatewayMethodMetadata");
            methodMetadataBuilder.addPropertyValue("requestChannelName", (Object)methodElement.getAttribute("request-channel"));
            methodMetadataBuilder.addPropertyValue("replyChannelName", (Object)methodElement.getAttribute("reply-channel"));
            methodMetadataBuilder.addPropertyValue("requestTimeout", (Object)methodElement.getAttribute("request-timeout"));
            methodMetadataBuilder.addPropertyValue("replyTimeout", (Object)methodElement.getAttribute("reply-timeout"));
            IntegrationNamespaceUtils.setValueIfAttributeDefined(methodMetadataBuilder, methodElement, "payload-expression");
            List invocationHeaders = DomUtils.getChildElementsByTagName((Element)methodElement, (String)"header");
            if (!CollectionUtils.isEmpty((Collection)invocationHeaders)) {
                this.setMethodInvocationHeaders(methodMetadataBuilder, invocationHeaders);
            }
            methodMetadataMap.put((Object)methodName, (Object)methodMetadataBuilder.getBeanDefinition());
        }
        builder.addPropertyValue("methodMetadataMap", (Object)methodMetadataMap);
    }

    private void setMethodInvocationHeaders(BeanDefinitionBuilder gatewayDefinitionBuilder, List<Element> invocationHeaders) {
        ManagedMap headerExpressions = new ManagedMap();
        for (Element headerElement : invocationHeaders) {
            boolean hasExpression;
            String headerName = headerElement.getAttribute("name");
            String headerValue = headerElement.getAttribute("value");
            String headerExpression = headerElement.getAttribute("expression");
            boolean hasValue = StringUtils.hasText((String)headerValue);
            if (!(hasValue ^ (hasExpression = StringUtils.hasText((String)headerExpression)))) {
                throw new BeanDefinitionStoreException("exactly one of 'value' or 'expression' is required on a header sub-element");
            }
            RootBeanDefinition expressionDef = null;
            if (hasValue) {
                expressionDef = new RootBeanDefinition("org.springframework.expression.common.LiteralExpression");
                expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)headerValue);
            } else if (hasExpression) {
                expressionDef = new RootBeanDefinition("org.springframework.integration.config.ExpressionFactoryBean");
                expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)headerExpression);
            }
            if (expressionDef == null) continue;
            headerExpressions.put(headerName, expressionDef);
        }
        gatewayDefinitionBuilder.addPropertyValue("headerExpressions", (Object)headerExpressions);
    }
}

