/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.HeaderEnricherParserSupport;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class StandardHeaderEnricherParser
extends HeaderEnricherParserSupport {
    public StandardHeaderEnricherParser() {
        this.addElementToHeaderMapping("reply-channel", "replyChannel");
        this.addElementToHeaderMapping("error-channel", "errorChannel");
        this.addElementToHeaderMapping("correlation-id", "correlationId");
        this.addElementToHeaderMapping("expiration-date", "expirationDate", Long.class);
        this.addElementToHeaderMapping("priority", "priority", Integer.class);
    }

    protected void postProcessHeaderEnricher(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
        String ref = element.getAttribute("ref");
        String method = element.getAttribute("method");
        if (StringUtils.hasText((String)ref) || StringUtils.hasText((String)method)) {
            if (!StringUtils.hasText((String)ref) || !StringUtils.hasText((String)method)) {
                parserContext.getReaderContext().error("If either 'ref' or 'method' is provided, then they are both required.", parserContext.extractSource((Object)element));
                return;
            }
            BeanDefinitionBuilder processorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.handler.MethodInvokingMessageProcessor");
            processorBuilder.addConstructorArgReference(ref);
            processorBuilder.addConstructorArgValue((Object)method);
            builder.addPropertyValue("messageProcessor", (Object)processorBuilder.getBeanDefinition());
        }
    }
}

