/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dispatcher;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.dispatcher.MessageDispatcher;
import org.springframework.integration.dispatcher.OrderedAwareCopyOnWriteArraySet;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDispatcher
implements MessageDispatcher {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile int maxSubscribers = Integer.MAX_VALUE;
    private final OrderedAwareCopyOnWriteArraySet<MessageHandler> handlers = new OrderedAwareCopyOnWriteArraySet();

    public void setMaxSubscribers(int maxSubscribers) {
        this.maxSubscribers = maxSubscribers;
    }

    protected Set<MessageHandler> getHandlers() {
        return this.handlers.asUnmodifiableSet();
    }

    @Override
    public boolean addHandler(MessageHandler handler) {
        Assert.notNull((Object)handler, (String)"handler must not be null");
        Assert.isTrue((this.handlers.size() < this.maxSubscribers ? 1 : 0) != 0, (String)"Maximum subscribers exceeded");
        return this.handlers.add(handler);
    }

    @Override
    public boolean removeHandler(MessageHandler handler) {
        Assert.notNull((Object)handler, (String)"handler must not be null");
        return this.handlers.remove(handler);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with handlers: " + this.handlers.toString();
    }

    public int getHandlerCount() {
        return this.handlers.size();
    }
}

