/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dispatcher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.integration.Message;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.MessageDispatchingException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.dispatcher.AggregateMessageDeliveryException;
import org.springframework.integration.dispatcher.LoadBalancingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicastingDispatcher
extends AbstractDispatcher {
    private volatile boolean failover = true;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private volatile LoadBalancingStrategy loadBalancingStrategy;
    private final Executor executor;

    public UnicastingDispatcher() {
        this.executor = null;
    }

    public UnicastingDispatcher(Executor executor) {
        this.executor = executor;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            this.loadBalancingStrategy = loadBalancingStrategy;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public final boolean dispatch(final Message<?> message) {
        if (this.executor != null) {
            this.executor.execute(new Runnable(){

                public void run() {
                    UnicastingDispatcher.this.doDispatch(message);
                }
            });
            return true;
        }
        return this.doDispatch(message);
    }

    private boolean doDispatch(Message<?> message) {
        boolean success = false;
        Iterator<MessageHandler> handlerIterator = this.getHandlerIterator(message);
        if (!handlerIterator.hasNext()) {
            throw new MessageDispatchingException(message, "Dispatcher has no subscribers");
        }
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        while (!success && handlerIterator.hasNext()) {
            MessageHandler handler = handlerIterator.next();
            try {
                handler.handleMessage(message);
                success = true;
            }
            catch (Exception e) {
                RuntimeException runtimeException;
                RuntimeException runtimeException2 = runtimeException = e instanceof RuntimeException ? (RuntimeException)e : new MessageDeliveryException(message, "Dispatcher failed to deliver Message.", e);
                if (e instanceof MessagingException && ((MessagingException)e).getFailedMessage() == null) {
                    ((MessagingException)e).setFailedMessage(message);
                }
                exceptions.add(runtimeException);
                this.handleExceptions(exceptions, message, !handlerIterator.hasNext());
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<MessageHandler> getHandlerIterator(Message<?> message) {
        Lock lock = this.rwLock.readLock();
        lock.lock();
        try {
            if (this.loadBalancingStrategy != null) {
                Iterator<MessageHandler> iterator = this.loadBalancingStrategy.getHandlerIterator(message, this.getHandlers());
                return iterator;
            }
        }
        finally {
            lock.unlock();
        }
        return this.getHandlers().iterator();
    }

    private void handleExceptions(List<RuntimeException> allExceptions, Message<?> message, boolean isLast) {
        if (isLast || !this.failover) {
            if (allExceptions != null && allExceptions.size() == 1) {
                throw allExceptions.get(0);
            }
            throw new AggregateMessageDeliveryException(message, "All attempts to deliver Message to MessageHandlers failed.", allExceptions);
        }
    }
}

