/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gateway;

import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessagingException;
import org.springframework.integration.core.MessagePostProcessor;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.core.PollableChannel;
import org.springframework.integration.core.SubscribableChannel;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.endpoint.EventDrivenConsumer;
import org.springframework.integration.endpoint.PollingConsumer;
import org.springframework.integration.handler.BridgeHandler;
import org.springframework.integration.history.HistoryWritingMessagePostProcessor;
import org.springframework.integration.history.TrackableComponent;
import org.springframework.integration.mapping.InboundMessageMapper;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.message.ErrorMessage;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.support.converter.SimpleMessageConverter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessagingGatewaySupport
extends AbstractEndpoint
implements TrackableComponent {
    private static final long DEFAULT_TIMEOUT = 1000L;
    private volatile MessageChannel requestChannel;
    private volatile MessageChannel replyChannel;
    private volatile MessageChannel errorChannel;
    private volatile long replyTimeout = 1000L;
    private volatile InboundMessageMapper requestMapper = new DefaultRequestMapper();
    private final SimpleMessageConverter messageConverter = new SimpleMessageConverter();
    private final MessagingTemplate messagingTemplate;
    private final HistoryWritingMessagePostProcessor historyWritingPostProcessor = new HistoryWritingMessagePostProcessor();
    private volatile boolean initialized;
    private volatile AbstractEndpoint replyMessageCorrelator;
    private final Object replyMessageCorrelatorMonitor = new Object();

    public MessagingGatewaySupport() {
        MessagingTemplate template = new MessagingTemplate();
        template.setMessageConverter(this.messageConverter);
        template.setSendTimeout(1000L);
        template.setReceiveTimeout(this.replyTimeout);
        this.messagingTemplate = template;
    }

    public void setRequestChannel(MessageChannel requestChannel) {
        this.requestChannel = requestChannel;
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.replyChannel = replyChannel;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.messagingTemplate.setSendTimeout(requestTimeout);
    }

    public void setReplyTimeout(long replyTimeout) {
        this.replyTimeout = replyTimeout;
        this.messagingTemplate.setReceiveTimeout(replyTimeout);
    }

    public void setRequestMapper(InboundMessageMapper<?> requestMapper) {
        requestMapper = requestMapper != null ? requestMapper : new DefaultRequestMapper();
        this.requestMapper = requestMapper;
        this.messageConverter.setInboundMessageMapper(requestMapper);
    }

    public void setReplyMapper(OutboundMessageMapper<?> replyMapper) {
        this.messageConverter.setOutboundMessageMapper(replyMapper);
    }

    @Override
    public void setShouldTrack(boolean shouldTrack) {
        this.historyWritingPostProcessor.setShouldTrack(shouldTrack);
    }

    @Override
    public String getComponentType() {
        return "gateway";
    }

    @Override
    protected void onInit() throws Exception {
        this.historyWritingPostProcessor.setTrackableComponent(this);
        this.initialized = true;
    }

    private void initializeIfNecessary() {
        if (!this.initialized) {
            this.afterPropertiesSet();
        }
    }

    protected void send(Object object) {
        this.initializeIfNecessary();
        Assert.notNull((Object)object, (String)"request must not be null");
        Assert.state((this.requestChannel != null ? 1 : 0) != 0, (String)"send is not supported, because no request channel has been configured");
        try {
            this.messagingTemplate.convertAndSend(this.requestChannel, object, (MessagePostProcessor)this.historyWritingPostProcessor);
        }
        catch (Exception e) {
            if (this.errorChannel != null) {
                this.messagingTemplate.send(this.errorChannel, new ErrorMessage(e));
            }
            this.rethrow(e, "failed to send message");
        }
    }

    protected Object receive() {
        this.initializeIfNecessary();
        Assert.state((this.replyChannel != null && this.replyChannel instanceof PollableChannel ? 1 : 0) != 0, (String)"receive is not supported, because no pollable reply channel has been configured");
        return this.messagingTemplate.receiveAndConvert((PollableChannel)this.replyChannel);
    }

    protected Object sendAndReceive(Object object) {
        return this.doSendAndReceive(object, true);
    }

    protected Message<?> sendAndReceiveMessage(Object object) {
        return (Message)this.doSendAndReceive(object, false);
    }

    private Object doSendAndReceive(Object object, boolean shouldConvert) {
        this.initializeIfNecessary();
        Assert.notNull((Object)object, (String)"request must not be null");
        if (this.requestChannel == null) {
            throw new MessagingException("No request channel available. Cannot send request message.");
        }
        if (this.replyChannel != null && this.replyMessageCorrelator == null) {
            this.registerReplyMessageCorrelator();
        }
        Message<?> reply = null;
        Throwable error = null;
        try {
            if (shouldConvert) {
                reply = this.messagingTemplate.convertSendAndReceive(this.requestChannel, object, (MessagePostProcessor)this.historyWritingPostProcessor);
                if (reply instanceof Throwable) {
                    error = (Throwable)((Object)reply);
                }
            } else {
                Message<?> requestMessage = object instanceof Message ? (Message<?>)object : this.requestMapper.toMessage(object);
                reply = this.messagingTemplate.sendAndReceive(this.requestChannel, requestMessage = this.historyWritingPostProcessor.postProcessMessage(requestMessage));
                if (reply instanceof ErrorMessage) {
                    error = (Throwable)((ErrorMessage)reply).getPayload();
                }
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"failure occurred in gateway sendAndReceive", (Throwable)e);
            error = e;
        }
        if (error != null) {
            if (this.errorChannel != null) {
                ErrorMessage errorMessage = new ErrorMessage(error);
                Message<?> errorFlowReply = null;
                try {
                    errorFlowReply = this.messagingTemplate.sendAndReceive(this.errorChannel, errorMessage);
                }
                catch (Exception errorFlowFailure) {
                    throw new MessagingException(errorMessage, "failure occurred in error-handling flow", errorFlowFailure);
                }
                if (shouldConvert) {
                    Object result;
                    Object v0 = result = errorFlowReply != null ? errorFlowReply.getPayload() : null;
                    if (result instanceof Throwable) {
                        this.rethrow(result, "error flow returned Exception");
                    }
                    return result;
                }
                if (errorFlowReply != null && errorFlowReply.getPayload() instanceof Throwable) {
                    this.rethrow((Throwable)errorFlowReply.getPayload(), "error flow returned an Error Message");
                }
                return errorFlowReply;
            }
            this.rethrow(error, "gateway received checked Exception");
        }
        return reply;
    }

    private void rethrow(Throwable t, String description) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new MessagingException(description, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerReplyMessageCorrelator() {
        Object object = this.replyMessageCorrelatorMonitor;
        synchronized (object) {
            if (this.replyMessageCorrelator != null) {
                return;
            }
            AbstractEndpoint correlator = null;
            BridgeHandler handler = new BridgeHandler();
            if (this.replyChannel instanceof SubscribableChannel) {
                correlator = new EventDrivenConsumer((SubscribableChannel)this.replyChannel, handler);
            } else if (this.replyChannel instanceof PollableChannel) {
                PollingConsumer endpoint = new PollingConsumer((PollableChannel)this.replyChannel, handler);
                endpoint.setBeanFactory(this.getBeanFactory());
                endpoint.setReceiveTimeout(this.replyTimeout);
                endpoint.afterPropertiesSet();
                correlator = endpoint;
            }
            if (this.isRunning()) {
                correlator.start();
            }
            this.replyMessageCorrelator = correlator;
        }
    }

    @Override
    protected void doStart() {
        if (this.replyMessageCorrelator != null) {
            this.replyMessageCorrelator.start();
        }
    }

    @Override
    protected void doStop() {
        if (this.replyMessageCorrelator != null) {
            this.replyMessageCorrelator.stop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultRequestMapper
    implements InboundMessageMapper<Object> {
        private DefaultRequestMapper() {
        }

        @Override
        public Message<?> toMessage(Object object) throws Exception {
            if (object instanceof Message) {
                return (Message)object;
            }
            return object != null ? MessageBuilder.withPayload(object).build() : null;
        }
    }
}

