/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.context.Orderable;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.history.TrackableComponent;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageHandler
extends IntegrationObjectSupport
implements MessageHandler,
TrackableComponent,
Orderable {
    private volatile boolean shouldTrack = false;
    private volatile int order = Integer.MAX_VALUE;

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public String getComponentType() {
        return "message-handler";
    }

    @Override
    public void setShouldTrack(boolean shouldTrack) {
        this.shouldTrack = shouldTrack;
    }

    @Override
    public final void handleMessage(Message<?> message) {
        Assert.notNull(message, (String)"Message must not be null");
        Assert.notNull(message.getPayload(), (String)"Message payload must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + " received message: " + message));
        }
        try {
            if (message != null && this.shouldTrack) {
                message = MessageHistory.write(message, this);
            }
            this.handleMessageInternal(message);
        }
        catch (Exception e) {
            if (e instanceof MessagingException) {
                throw (MessagingException)e;
            }
            throw new MessageHandlingException(message, "error occurred in message handler [" + this + "]", e);
        }
    }

    protected abstract void handleMessageInternal(Message<?> var1) throws Exception;
}

